/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Map;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.util.CollectionFactory;

public class WeakIndexCache<K, V>
implements Serializable {
    private static final long serialVersionUID = 40000L;
    protected transient Map<K, WeakReference<V>> prefixCache = CollectionFactory.createSyncWeakMap();

    @Nonnull
    public V cache(@Nonnull K s2, @Nonnull V v) {
        Object toReturn;
        WeakReference<V> w = this.prefixCache.get(s2);
        if (w != null && (toReturn = w.get()) != null) {
            return (V)toReturn;
        }
        this.prefixCache.put(s2, new WeakReference<V>(v));
        return v;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.prefixCache = CollectionFactory.createSyncWeakMap();
    }

    public V get(K k) {
        WeakReference<V> w = this.prefixCache.get(k);
        if (w != null) {
            return (V)w.get();
        }
        return null;
    }

    public boolean contains(K k) {
        Object toReturn;
        WeakReference<V> w = this.prefixCache.get(k);
        return w != null && (toReturn = w.get()) != null;
    }

    public void clear() {
        this.prefixCache.clear();
    }
}

