/*
 * Decompiled with CFR 0.152.
 */
package org.tap4j.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Map;
import java.util.Scanner;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tap4j.model.BailOut;
import org.tap4j.model.Comment;
import org.tap4j.model.Footer;
import org.tap4j.model.Header;
import org.tap4j.model.Plan;
import org.tap4j.model.TapElement;
import org.tap4j.model.TapElementFactory;
import org.tap4j.model.TestResult;
import org.tap4j.model.TestSet;
import org.tap4j.model.Text;
import org.tap4j.parser.Parser;
import org.tap4j.parser.ParserException;
import org.tap4j.parser.StreamStatus;
import org.yaml.snakeyaml.Yaml;

public class Tap13Parser
implements Parser {
    private static final Logger LOGGER = Logger.getLogger(Tap13Parser.class.getCanonicalName());
    private Stack<StreamStatus> states = new Stack();
    private StreamStatus state = null;
    private int baseIndentation;
    private CharsetDecoder decoder;
    private boolean planRequired = true;

    public Tap13Parser(String encoding, boolean enableSubtests) {
        this(encoding, enableSubtests, true);
    }

    public Tap13Parser(String encoding, boolean enableSubtests, boolean planRequired) {
        try {
            if (null != encoding) {
                this.decoder = Charset.forName(encoding).newDecoder();
            }
        }
        catch (UnsupportedCharsetException uce) {
            throw new ParserException("Invalid encoding: " + encoding, uce);
        }
        this.planRequired = planRequired;
    }

    public Tap13Parser(boolean enableSubtests) {
        this("UTF-8", enableSubtests);
    }

    public Tap13Parser() {
        this("UTF-8", false);
    }

    private void pushState(int indentation) {
        this.states.push(this.state);
        this.state = new StreamStatus();
        this.state.setIndentationLevel(indentation);
    }

    @Override
    public TestSet parseTapStream(String tapStream) {
        return this.parseTapStream(CharBuffer.wrap(tapStream));
    }

    @Override
    public TestSet parseFile(File tapFile) {
        if (null == this.decoder) {
            throw new ParserException("Must have encoding specified if using parseFile");
        }
        FileInputStream fis = null;
        InputStreamReader isr = null;
        try {
            fis = new FileInputStream(tapFile);
            isr = new InputStreamReader((InputStream)fis, this.decoder);
            TestSet testSet = this.parseTapStream(isr);
            return testSet;
        }
        catch (FileNotFoundException e) {
            throw new ParserException("TAP file not found: " + tapFile, e);
        }
        finally {
            try {
                if (isr != null) {
                    isr.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Failed to close file stream: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public TestSet parseTapStream(Readable tapStream) {
        this.state = new StreamStatus();
        this.baseIndentation = Integer.MAX_VALUE;
        Scanner scanner = null;
        try {
            scanner = new Scanner(tapStream);
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (line == null || line.length() <= 0) continue;
                this.parseLine(line);
            }
            this.onFinish();
        }
        catch (Exception e) {
            throw new ParserException("Error parsing TAP Stream: " + e.getMessage(), e);
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
        return this.state.getTestSet();
    }

    public void parseLine(String tapLine) {
        TapElement tapElement = TapElementFactory.createTapElement(tapLine);
        if (tapElement == null || this.state.isInYaml()) {
            String trimmedLine = tapLine.trim();
            Text text = TapElementFactory.createTextElement(tapLine);
            if (this.state.isInYaml()) {
                boolean yamlEndMarkReached;
                boolean bl = yamlEndMarkReached = trimmedLine.equals("...") && (tapLine.equals(this.state.getYamlIndentation() + "...") || text.getIndentation() < this.state.getYamlIndentation().length());
                if (yamlEndMarkReached) {
                    this.state.setInYaml(false);
                    this.parseDiagnostics();
                } else {
                    this.state.getDiagnosticBuffer().append(tapLine);
                    this.state.getDiagnosticBuffer().append('\n');
                }
            } else if (trimmedLine.equals("---")) {
                if (text.getIndentation() < this.baseIndentation) {
                    throw new ParserException("Invalid indentation. Check your TAP Stream. Line: " + tapLine);
                }
                this.state.setInYaml(true);
                this.state.setYamlIndentation(text.getIndentationString());
            } else {
                this.state.getTestSet().getTapLines().add(text);
                this.state.setLastParsedElement(text);
            }
            return;
        }
        int indentation = tapElement.getIndentation();
        if (indentation < this.baseIndentation) {
            this.baseIndentation = indentation;
        }
        if (indentation != this.state.getIndentationLevel()) {
            if (indentation > this.state.getIndentationLevel()) {
                TestResult lastTestResult;
                StreamStatus parentState = this.state;
                this.pushState(indentation);
                TapElement lastParentElement = parentState.getLastParsedElement();
                if (lastParentElement instanceof TestResult && (lastTestResult = (TestResult)lastParentElement).getSubtest() == null) {
                    lastTestResult.setSubtest(this.state.getTestSet());
                    this.state.attachedToParent = true;
                }
            } else {
                do {
                    StreamStatus prevState = this.state;
                    this.state = this.states.pop();
                    if (prevState.attachedToParent) continue;
                    this.state.looseSubtests = prevState.getTestSet();
                } while (indentation < this.state.getIndentationLevel());
            }
        }
        if (tapElement instanceof Header) {
            if (this.state.getTestSet().getHeader() != null) {
                throw new ParserException("Duplicated TAP Header found.");
            }
            if (!this.state.isFirstLine()) {
                throw new ParserException("Invalid position of TAP Header. It must be the first element (apart of Comments) in the TAP Stream.");
            }
            this.state.getTestSet().setHeader((Header)tapElement);
        } else if (tapElement instanceof Plan) {
            Plan currentPlan = (Plan)tapElement;
            if (this.state.getTestSet().getPlan() != null) {
                if (currentPlan.getInitialTestNumber() != 1 || currentPlan.getLastTestNumber() != 0) {
                    throw new ParserException("Duplicated TAP Plan found.");
                }
            } else {
                this.state.getTestSet().setPlan(currentPlan);
            }
            if (this.state.getTestSet().getTestResults().size() <= 0 && this.state.getTestSet().getBailOuts().size() <= 0) {
                this.state.setPlanBeforeTestResult(true);
            }
        } else if (tapElement instanceof TestResult) {
            this.parseDiagnostics();
            TestResult testResult = (TestResult)tapElement;
            if (testResult.getTestNumber() == 0) {
                if (this.state.getTestSet().getPlan() != null && !this.state.isPlanBeforeTestResult()) {
                    return;
                }
                if (this.state.getTestSet().getPlan() != null && this.state.getTestSet().getPlan().getLastTestNumber().intValue() == this.state.getTestSet().getTestResults().size()) {
                    return;
                }
                testResult.setTestNumber(this.state.getTestSet().getNextTestNumber());
            }
            this.state.getTestSet().addTestResult(testResult);
            if (this.state.looseSubtests != null) {
                testResult.setSubtest(this.state.looseSubtests);
                this.state.looseSubtests = null;
            }
        } else if (tapElement instanceof Footer) {
            this.state.getTestSet().setFooter((Footer)tapElement);
        } else if (tapElement instanceof BailOut) {
            this.state.getTestSet().addBailOut((BailOut)tapElement);
        } else if (tapElement instanceof Comment) {
            Comment comment = (Comment)tapElement;
            this.state.getTestSet().addComment(comment);
            if (this.state.getLastParsedElement() instanceof TestResult) {
                ((TestResult)this.state.getLastParsedElement()).addComment(comment);
            }
        }
        this.state.setFirstLine(false);
        if (!(tapElement instanceof Comment)) {
            this.state.setLastParsedElement(tapElement);
        }
    }

    private void onFinish() {
        if (this.planRequired && this.state.getTestSet().getPlan() == null) {
            throw new ParserException("Missing TAP Plan.");
        }
        this.parseDiagnostics();
        while (!this.states.isEmpty() && this.state.getIndentationLevel() > this.baseIndentation) {
            this.state = this.states.pop();
        }
    }

    private void parseDiagnostics() {
        if (this.state.getDiagnosticBuffer().length() > 0) {
            if (this.state.getLastParsedElement() == null) {
                throw new ParserException("Found diagnostic information without a previous TAP element.");
            }
            try {
                Map metaIterable = (Map)new Yaml().load(this.state.getDiagnosticBuffer().toString());
                this.state.getLastParsedElement().setDiagnostic(metaIterable);
            }
            catch (Exception ex) {
                throw new ParserException("Error parsing YAML [" + this.state.getDiagnosticBuffer().toString() + "]: " + ex.getMessage(), ex);
            }
            this.state.getDiagnosticBuffer().setLength(0);
        }
    }
}

