/*
 * Decompiled with CFR 0.152.
 */
package org.tap4j.producer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tap4j.model.TestSet;
import org.tap4j.producer.Producer;
import org.tap4j.producer.ProducerException;
import org.tap4j.representer.Representer;
import org.tap4j.representer.RepresenterException;
import org.tap4j.representer.Tap13Representer;

public class TapProducer
implements Producer {
    private static final Logger LOGGER = Logger.getLogger(TapProducer.class.getCanonicalName());
    private Representer representer;

    public TapProducer() {
        this.representer = new Tap13Representer();
    }

    public TapProducer(Representer representer) {
        this.representer = representer;
    }

    @Override
    public String dump(TestSet testSet) {
        String dumpData = null;
        try {
            dumpData = this.representer.representData(testSet);
        }
        catch (RepresenterException re) {
            throw new ProducerException("Failed to produce test set dump: " + re.getMessage(), re);
        }
        return dumpData;
    }

    @Override
    public void dump(TestSet testSet, Writer writer) {
        String tapStream = null;
        try {
            tapStream = this.dump(testSet);
        }
        catch (RepresenterException re) {
            throw new ProducerException("Failed to dump Test Set to writer: " + re.getMessage(), re);
        }
        try {
            writer.append(tapStream);
        }
        catch (IOException e) {
            throw new ProducerException("Failed to dump TAP Stream: " + e.getMessage(), e);
        }
    }

    @Override
    public void dump(TestSet testSet, File output) {
        FileOutputStream outputStream = null;
        OutputStreamWriter writer = null;
        try {
            Charset charset = null;
            charset = this.representer instanceof Tap13Representer ? Charset.forName(((Tap13Representer)this.representer).getOptions().getCharset()) : Charset.defaultCharset();
            outputStream = new FileOutputStream(output);
            writer = new OutputStreamWriter((OutputStream)outputStream, charset.newEncoder());
            this.dump(testSet, writer);
        }
        catch (IOException e) {
            throw new ProducerException("Failed to dump TAP Stream: " + e.getMessage(), e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Failed to close file stream: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public Representer getRepresenter() {
        return this.representer;
    }
}

