/*
 * Decompiled with CFR 0.152.
 */
package org.tap4j.representer;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import org.tap4j.model.BailOut;
import org.tap4j.model.Comment;
import org.tap4j.model.Footer;
import org.tap4j.model.Header;
import org.tap4j.model.Plan;
import org.tap4j.model.TapElement;
import org.tap4j.model.TestResult;
import org.tap4j.model.TestSet;
import org.tap4j.representer.DumperOptions;
import org.tap4j.representer.Representer;
import org.tap4j.representer.RepresenterException;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class Tap13Representer
implements Representer {
    private static final CharSequence LINE_SEPARATOR = "\n";
    private DumperOptions options;
    private Yaml yaml = null;

    public Tap13Representer() {
        this(new DumperOptions());
    }

    public Tap13Representer(DumperOptions options) {
        this.options = options;
        if (options.isPrintDiagnostics()) {
            org.yaml.snakeyaml.DumperOptions yamlDumperOptions = new org.yaml.snakeyaml.DumperOptions();
            yamlDumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            yamlDumperOptions.setLineBreak(DumperOptions.LineBreak.getPlatformLineBreak());
            yamlDumperOptions.setExplicitStart(true);
            yamlDumperOptions.setExplicitEnd(true);
            this.yaml = new Yaml(yamlDumperOptions);
        }
    }

    public DumperOptions getOptions() {
        return this.options;
    }

    @Override
    public String representData(TestSet testSet) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.printHeader(pw, testSet.getHeader());
        this.printPlan(pw, testSet.getPlan());
        for (TapElement tapLine : testSet.getTapLines()) {
            this.printTapLine(pw, tapLine);
        }
        this.printFooter(pw, testSet.getFooter());
        return sw.toString();
    }

    protected void printTapLine(PrintWriter pw, TapElement tapResult) {
        if (tapResult instanceof BailOut) {
            this.printBailOut(pw, (BailOut)tapResult);
        } else if (tapResult instanceof Comment) {
            this.printComment(pw, (Comment)tapResult);
            pw.append(LINE_SEPARATOR);
        } else if (tapResult instanceof TestResult) {
            this.printTestResult(pw, (TestResult)tapResult);
        }
    }

    protected void printTestResult(PrintWriter pw, TestResult testResult) {
        List<Comment> comments;
        this.printFiller(pw);
        pw.append(testResult.getStatus().toString());
        pw.append(' ' + Integer.toString(testResult.getTestNumber()));
        if (testResult.getDescription() != null && testResult.getDescription().trim().length() > 0) {
            pw.append(' ' + testResult.getDescription());
        }
        if (testResult.getDirective() != null) {
            pw.append(" # " + testResult.getDirective().getDirectiveValue().toString());
            String reason = testResult.getDirective().getReason();
            if (reason != null && reason.trim().length() > 0) {
                pw.append(' ' + testResult.getDirective().getReason());
            }
        }
        if ((comments = testResult.getComments()).size() > 0) {
            for (Comment comment : comments) {
                if (comment.isInline()) {
                    pw.append(' ');
                    this.printComment(pw, comment);
                    continue;
                }
                pw.append(LINE_SEPARATOR);
                this.printComment(pw, comment);
            }
        }
        this.printDiagnostic(pw, testResult);
        pw.append(LINE_SEPARATOR);
        if (testResult.getSubtest() != null) {
            int indent = this.options.getIndent();
            int spaces = this.options.getSpaces();
            this.options.setIndent(indent + spaces);
            pw.append(this.representData(testResult.getSubtest()));
            this.options.setIndent(indent);
        }
    }

    protected void printBailOut(PrintWriter pw, BailOut bailOut) {
        this.printFiller(pw);
        pw.append("Bail out!");
        if (bailOut.getReason() != null) {
            pw.append(' ' + bailOut.getReason());
        }
        if (bailOut.getComment() != null) {
            pw.append(' ');
            this.printComment(pw, bailOut.getComment());
        }
        this.printDiagnostic(pw, bailOut);
        pw.append(LINE_SEPARATOR);
    }

    protected void printFooter(PrintWriter pw, Footer footer) {
        if (footer != null) {
            this.printFiller(pw);
            pw.append("TAP " + footer.getText());
            if (footer.getComment() != null) {
                pw.append(' ');
                this.printComment(pw, footer.getComment());
            }
            this.printDiagnostic(pw, footer);
            pw.append(LINE_SEPARATOR);
        }
    }

    protected void printPlan(PrintWriter pw, Plan plan) {
        if (plan != null) {
            this.printFiller(pw);
            pw.append(plan.getInitialTestNumber() + ".." + plan.getLastTestNumber());
            if (plan.getSkip() != null) {
                pw.append(" skip ");
                pw.append(plan.getSkip().getReason());
            }
            if (plan.getComment() != null) {
                pw.append(' ');
                this.printComment(pw, plan.getComment());
            }
            this.printDiagnostic(pw, plan);
            pw.append(LINE_SEPARATOR);
        } else if (this.options.isAllowEmptyTestPlan() == Boolean.FALSE.booleanValue()) {
            throw new RepresenterException("Missing required TAP Plan");
        }
    }

    protected void printHeader(PrintWriter pw, Header header) {
        if (header != null) {
            this.printFiller(pw);
            pw.append("TAP version " + header.getVersion());
            if (header.getComment() != null) {
                pw.append(' ');
                this.printComment(pw, header.getComment());
            }
            this.printDiagnostic(pw, header);
            pw.append(LINE_SEPARATOR);
        }
    }

    protected void printComment(PrintWriter pw, Comment comment) {
        pw.append("# " + comment.getText());
    }

    protected void printDiagnostic(PrintWriter pw, TapElement tapElement) {
        Map<String, Object> diagnostic;
        if (this.yaml != null && (diagnostic = tapElement.getDiagnostic()) != null && !diagnostic.isEmpty()) {
            String diagnosticText = this.yaml.dump(diagnostic);
            diagnosticText = diagnosticText.replaceAll("((?m)^)", "  ");
            pw.append(LINE_SEPARATOR);
            this.printFiller(pw);
            pw.append(diagnosticText);
        }
    }

    protected void printFiller(PrintWriter pw) {
        if (this.options.getIndent() > 0) {
            for (int i = 0; i < this.options.getIndent(); ++i) {
                pw.append(' ');
            }
        }
    }
}

