/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.events;

import java.util.HashMap;
import java.util.Map;
import org.piangles.backbone.services.Locator;
import org.piangles.backbone.services.logging.LoggingService;
import org.piangles.backbone.services.msg.ControlDetails;
import org.piangles.backbone.services.msg.Event;
import org.piangles.backbone.services.msg.EventType;
import org.piangles.core.util.coding.JSON;
import org.piangles.gateway.events.EventProcessor;
import org.piangles.gateway.events.processors.PassThruControlEventProcessor;
import org.piangles.gateway.events.processors.PassThruNotificationEventProcessor;

public class EventRouter {
    private LoggingService logger = Locator.getInstance().getLoggingService();
    private static EventRouter self = null;
    private boolean automaticPassThru = false;
    private EventProcessor passThruControlProcessor = null;
    private EventProcessor passThruNotificationProcessor = null;
    private Map<String, EventProcessor> eventProcessorMap = new HashMap<String, EventProcessor>();

    private EventRouter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EventRouter getInstance() {
        if (self != null) return self;
        Class<EventRouter> clazz = EventRouter.class;
        synchronized (EventRouter.class) {
            if (self != null) return self;
            self = new EventRouter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return self;
        }
    }

    public EventProcessor getProcessor(Event event) throws Exception {
        String processorId = null;
        switch (event.getType()) {
            case Control: {
                ControlDetails controlDetails = (ControlDetails)JSON.getDecoder().decode(((String)event.getPayload()).getBytes(), ControlDetails.class);
                processorId = this.createControlEventProcessorId(controlDetails.getType());
                break;
            }
            case Notification: {
                processorId = event.getPayloadType();
            }
        }
        EventProcessor ep = this.eventProcessorMap.get(processorId);
        if (ep == null && this.automaticPassThru) {
            ep = event.getType() == EventType.Control ? this.passThruControlProcessor : this.passThruNotificationProcessor;
        } else {
            this.logger.error((Object)("Unable to find EventProcessor for:" + processorId));
        }
        return ep;
    }

    public void registerControlProcessor(String contolPayloadType, EventProcessor eventProcessor) {
        this.register(this.createControlEventProcessorId(contolPayloadType), eventProcessor);
    }

    public void registerNotificationProcessor(EventProcessor eventProcessor) {
        this.register(eventProcessor.getType(), eventProcessor);
    }

    public void registerPassThruProcessor(EventType type, String payloadType) {
        String processorId = null;
        EventProcessor ep = null;
        if (type == EventType.Control) {
            ep = new PassThruControlEventProcessor();
            processorId = this.createControlEventProcessorId(payloadType);
        } else if (type == EventType.Notification) {
            processorId = payloadType;
            ep = new PassThruNotificationEventProcessor(payloadType);
        }
        this.register(processorId, ep);
    }

    private void register(String processorId, EventProcessor eventProcessor) {
        if (this.eventProcessorMap.containsKey(processorId)) {
            throw new RuntimeException("Event Router already has a registered endpoint : " + eventProcessor.getType());
        }
        this.logger.info((Object)("Registering EventProcessor for Id:" + processorId));
        this.eventProcessorMap.put(processorId, eventProcessor);
    }

    public void enableAutomaticPassThru() {
        this.automaticPassThru = true;
        this.passThruControlProcessor = new PassThruControlEventProcessor();
        this.passThruNotificationProcessor = new PassThruNotificationEventProcessor("AutoPassThru");
    }

    public boolean isAutomaticPassThru() {
        this.logger.info((Object)"AutomaticPassThru enabled:  PassThru EventProcessor will be used when processorId is not found.");
        return this.automaticPassThru;
    }

    private String createControlEventProcessorId(String controlPayloadType) {
        return ControlDetails.class.getCanonicalName() + ":" + controlPayloadType;
    }
}

