/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.requests;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.piangles.backbone.services.Locator;
import org.piangles.backbone.services.logging.LoggingService;
import org.piangles.gateway.requests.Endpoints;
import org.piangles.gateway.requests.RequestProcessor;
import org.piangles.gateway.requests.processors.AutoSuggestRequestProcessor;
import org.piangles.gateway.requests.processors.ChangePasswordRequestProcessor;
import org.piangles.gateway.requests.processors.CreateUserProfileRequestProcessor;
import org.piangles.gateway.requests.processors.EndpointMetadataRequestProcessor;
import org.piangles.gateway.requests.processors.GenerateTokenRequestProcessor;
import org.piangles.gateway.requests.processors.GetConfigRequestProcessor;
import org.piangles.gateway.requests.processors.GetUserPreferenceRequestProcessor;
import org.piangles.gateway.requests.processors.GetUserProfileRequestProcessor;
import org.piangles.gateway.requests.processors.KeepSessionAliveRequestProcessor;
import org.piangles.gateway.requests.processors.ListEndpointsRequestProcessor;
import org.piangles.gateway.requests.processors.LoginRequestProcessor;
import org.piangles.gateway.requests.processors.LogoutRequestProcessor;
import org.piangles.gateway.requests.processors.PingMessageProcessor;
import org.piangles.gateway.requests.processors.SignUpRequestProcessor;
import org.piangles.gateway.requests.processors.SubscribeRequestProcessor;
import org.piangles.gateway.requests.processors.UpdateUserPreferenceRequestProcessor;
import org.piangles.gateway.requests.processors.UpdateUserProfileRequestProcessor;

public class RequestRouter {
    private LoggingService logger = Locator.getInstance().getLoggingService();
    private static RequestRouter self = null;
    private Map<String, Enum<?>> preAuthenticationEndpoints = new HashMap();
    private Map<String, RequestProcessor> endpointRequestProcessorMap = new HashMap<String, RequestProcessor>();

    private RequestRouter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RequestRouter getInstance() {
        if (self != null) return self;
        Class<RequestRouter> clazz = RequestRouter.class;
        synchronized (RequestRouter.class) {
            if (self != null) return self;
            self = new RequestRouter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return self;
        }
    }

    public void registerDefaultPreAuthenticationEndpoints() {
        this.registerPreAuthenticationEndpoint(Endpoints.ListEndpoints.name(), Endpoints.ListEndpoints);
        this.registerPreAuthenticationEndpoint(Endpoints.EndpointMetadata.name(), Endpoints.EndpointMetadata);
        this.registerPreAuthenticationEndpoint(Endpoints.SignUp.name(), Endpoints.SignUp);
        this.registerPreAuthenticationEndpoint(Endpoints.Login.name(), Endpoints.Login);
        this.registerPreAuthenticationEndpoint(Endpoints.GenerateResetToken.name(), Endpoints.GenerateResetToken);
    }

    public void registerDefaultRequestProcessors() {
        this.registerRequestProcessor(this.createRequestProcessor(ListEndpointsRequestProcessor.class));
        this.registerRequestProcessor(this.createRequestProcessor(EndpointMetadataRequestProcessor.class));
        this.registerRequestProcessor(this.createRequestProcessor(SignUpRequestProcessor.class));
        this.registerRequestProcessor(this.createRequestProcessor(LoginRequestProcessor.class));
        this.registerRequestProcessor(this.createRequestProcessor(GenerateTokenRequestProcessor.class));
        this.registerRequestProcessor(this.createRequestProcessor(ChangePasswordRequestProcessor.class));
        this.registerRequestProcessor(this.createRequestProcessor(LogoutRequestProcessor.class));
        this.registerRequestProcessor(this.createRequestProcessor(PingMessageProcessor.class));
        this.registerRequestProcessor(this.createRequestProcessor(KeepSessionAliveRequestProcessor.class));
        this.registerRequestProcessor(this.createRequestProcessor(CreateUserProfileRequestProcessor.class));
        this.registerRequestProcessor(this.createRequestProcessor(UpdateUserProfileRequestProcessor.class));
        this.registerRequestProcessor(this.createRequestProcessor(GetUserProfileRequestProcessor.class));
        this.registerRequestProcessor(this.createRequestProcessor(GetConfigRequestProcessor.class));
        this.registerRequestProcessor(this.createRequestProcessor(GetUserPreferenceRequestProcessor.class));
        this.registerRequestProcessor(this.createRequestProcessor(UpdateUserPreferenceRequestProcessor.class));
        this.registerRequestProcessor(this.createRequestProcessor(SubscribeRequestProcessor.class));
        this.registerRequestProcessor(this.createRequestProcessor(AutoSuggestRequestProcessor.class));
    }

    public void registerPreAuthenticationEndpoint(String endpointName, Enum<?> endpoint) {
        this.preAuthenticationEndpoints.put(endpointName, endpoint);
    }

    public boolean isPreAuthenticationEndpoint(String endpoint) {
        return this.preAuthenticationEndpoints.containsKey(endpoint);
    }

    public Set<String> getRegisteredEndpoints() {
        return this.endpointRequestProcessorMap.keySet();
    }

    public RequestProcessor getRequestProcessor(String endpoint) {
        return this.endpointRequestProcessorMap.get(endpoint);
    }

    public void clear() {
        this.endpointRequestProcessorMap.clear();
    }

    public void registerRequestProcessor(RequestProcessor rp) {
        if (rp != null) {
            String registringOrOverriding = null;
            RequestProcessor existingRP = this.endpointRequestProcessorMap.get(rp.getEndpoint().name());
            if (existingRP != null) {
                this.logger.warn((Object)("Request Router already has a registered endpoint : " + rp.getEndpoint() + " : " + existingRP.getClass().getCanonicalName()));
                registringOrOverriding = "Overriding";
            } else {
                registringOrOverriding = "Registering";
            }
            this.logger.info((Object)(registringOrOverriding + " " + rp.getEndpoint() + " with : " + rp.getClass().getCanonicalName()));
            this.endpointRequestProcessorMap.put(rp.getEndpoint().name(), rp);
        } else {
            this.logger.error((Object)"registerRequestProcessor: RequestProcessor is null.");
        }
    }

    private RequestProcessor createRequestProcessor(Class<?> rpClass) {
        RequestProcessor rp = null;
        try {
            rp = (RequestProcessor)rpClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            this.logger.warn((Object)("Unable to create " + rpClass.getCanonicalName() + " because of : " + e.getMessage()));
        }
        return rp;
    }
}

