/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.requests.processors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.piangles.backbone.services.Locator;
import org.piangles.backbone.services.msg.MessagingService;
import org.piangles.backbone.services.msg.Topic;
import org.piangles.gateway.client.ClientDetails;
import org.piangles.gateway.requests.Endpoints;
import org.piangles.gateway.requests.dto.Request;
import org.piangles.gateway.requests.dto.SimpleResponse;
import org.piangles.gateway.requests.dto.SubscribeRequest;
import org.piangles.gateway.requests.processors.AbstractRequestProcessor;

public class SubscribeRequestProcessor
extends AbstractRequestProcessor<SubscribeRequest, SimpleResponse> {
    private MessagingService msgService = Locator.getInstance().getMessagingService();

    public SubscribeRequestProcessor() {
        super(Endpoints.Subscribe, SubscribeRequest.class, SimpleResponse.class);
    }

    @Override
    public SimpleResponse processRequest(ClientDetails clientDetails, Request request, SubscribeRequest subscribeRequest) throws Exception {
        boolean result = true;
        String message = "Subscription was successful.";
        List<Object> topics = null;
        if (subscribeRequest.isUserTopics()) {
            topics = this.msgService.getTopicsForUser(clientDetails.getSessionDetails().getUserId());
            if (topics == null) {
                result = false;
                message = "User does not have any associated topics.";
            }
        } else if (subscribeRequest.getAliases() != null) {
            topics = this.msgService.getTopicsForAliases(subscribeRequest.getAliases());
            if (topics == null) {
                result = false;
                message = "Alias does not have any associated topics.";
            }
        } else if (subscribeRequest.getTopic() != null) {
            topics = new ArrayList<Topic>();
            Topic topic2 = this.msgService.getTopic(subscribeRequest.getTopic());
            topics.add(topic2);
        } else {
            result = false;
            message = "None of the mandatory fields are specified.";
        }
        if (topics != null) {
            HashMap<Topic, UUID> topicTraceIdMap = new HashMap<Topic, UUID>();
            topics.stream().forEach(topic -> topicTraceIdMap.put((Topic)topic, request.getTraceId()));
            this.getEventProcessingManager().subscribeToTopics(topicTraceIdMap);
            this.getEventProcessingManager().restart();
        }
        return new SimpleResponse(result, message);
    }
}

