/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.requests;

import org.piangles.backbone.services.Locator;
import org.piangles.backbone.services.logging.LoggingService;
import org.piangles.backbone.services.session.SessionManagementException;
import org.piangles.backbone.services.session.SessionManagementService;
import org.piangles.core.services.remoting.AbstractContextAwareThread;
import org.piangles.gateway.client.ClientDetails;
import org.piangles.gateway.events.EventProcessingManager;
import org.piangles.gateway.events.KafkaConsumerManager;
import org.piangles.gateway.requests.RequestProcessor;
import org.piangles.gateway.requests.RequestRouter;
import org.piangles.gateway.requests.ResponseSender;
import org.piangles.gateway.requests.dto.Request;
import org.piangles.gateway.requests.dto.Response;
import org.piangles.gateway.requests.dto.StatusCode;

public final class RequestProcessingThread
extends AbstractContextAwareThread {
    private ClientDetails clientDetails = null;
    private Request request = null;
    private Response response = null;
    private EventProcessingManager mpm = null;
    private RequestProcessor requestProcessor = null;
    private SessionManagementService sessionMgmtService = Locator.getInstance().getSessionManagementService();
    protected LoggingService logger = Locator.getInstance().getLoggingService();

    public RequestProcessingThread(ClientDetails clientDetails, Request request, RequestProcessor requestProcessor, EventProcessingManager mpm) {
        super.init(clientDetails.getSessionDetails(), request.getTraceId());
        this.clientDetails = clientDetails;
        this.request = request;
        this.requestProcessor = requestProcessor;
        this.mpm = mpm;
    }

    public void run() {
        boolean validSession;
        block12: {
            this.logger.info((Object)("Processing request for Endpoint : " + this.request.getEndpoint()));
            KafkaConsumerManager.getInstance().closeAnyMarked();
            validSession = false;
            if (RequestRouter.getInstance().isPreAuthenticationEndpoint(this.requestProcessor.getEndpoint().name())) {
                validSession = true;
            } else if (this.requestProcessor.shouldValidateSession()) {
                try {
                    validSession = this.sessionMgmtService.isValid(this.clientDetails.getSessionDetails().getUserId(), this.clientDetails.getSessionDetails().getSessionId());
                    if (validSession) {
                        this.sessionMgmtService.makeLastAccessedCurrent(this.clientDetails.getSessionDetails().getUserId(), this.clientDetails.getSessionDetails().getSessionId());
                        break block12;
                    }
                    this.response = new Response(this.request.getTraceId(), this.request.getEndpoint(), this.request.getReceiptTime(), this.request.getTransitTime(), StatusCode.UnAuthenticated, "Invalid sessionId.");
                }
                catch (SessionManagementException e) {
                    this.logger.error((Object)("Unable to validate Session because of : " + e.getMessage()), (Throwable)e);
                    validSession = false;
                    this.response = new Response(this.request.getTraceId(), this.request.getEndpoint(), this.request.getReceiptTime(), this.request.getTransitTime(), StatusCode.InternalError, "Unable to authenticate validate session.");
                }
            } else if (this.clientDetails.getSessionDetails().getSessionId() != null) {
                validSession = true;
                this.logger.warn((Object)("RequestProcessor for endpoint " + this.requestProcessor.getEndpoint() + " has a sessionId but is coded for not validating session."));
            }
        }
        try {
            if (validSession) {
                this.response = this.requestProcessor.processRequest(this.clientDetails, this.request);
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)("Exception while processing request because of : " + e.getMessage()), (Throwable)e);
            this.response = new Response(this.getTraceId(), this.request.getEndpoint(), this.request.getReceiptTime(), this.request.getTransitTime(), StatusCode.InternalError, StatusCode.InternalError.getMessage());
        }
        catch (Throwable e) {
            this.logger.error((Object)("Unhandled Exception while processing request because of : " + e.getMessage()), e);
            this.response = new Response(this.getTraceId(), this.request.getEndpoint(), this.request.getReceiptTime(), this.request.getTransitTime(), StatusCode.InternalError, StatusCode.InternalError.getMessage());
        }
        ResponseSender.sendResponse(this.clientDetails, this.response);
    }

    public Response getResponse() {
        return this.response;
    }

    public EventProcessingManager getMessageProcessingManager() {
        return this.mpm;
    }
}

