/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.requests.dto;

import java.util.UUID;
import org.piangles.gateway.requests.dto.SystemInfo;

public final class Request {
    private long issuedTime = System.currentTimeMillis();
    private long receiptTime;
    private long transitTime;
    private UUID traceId = UUID.randomUUID();
    private String sessionId = null;
    private String endPoint = null;
    private String endpointRequest = null;
    private SystemInfo systemInfo = null;

    public Request(String sessionId, String endPoint, String endpointRequest, SystemInfo systemInfo) {
        this.sessionId = sessionId;
        this.endPoint = endPoint;
        this.endpointRequest = endpointRequest;
        this.systemInfo = systemInfo;
    }

    public long getIssuedTime() {
        return this.issuedTime;
    }

    public long getReceiptTime() {
        return this.receiptTime;
    }

    public void markTransitTime() {
        this.receiptTime = System.currentTimeMillis();
        this.transitTime = this.receiptTime - this.issuedTime;
    }

    public long getTransitTime() {
        return this.transitTime;
    }

    public UUID getTraceId() {
        return this.traceId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getEndpoint() {
        return this.endPoint;
    }

    public String getEndpointRequest() {
        return this.endpointRequest;
    }

    public SystemInfo getSystemInfo() {
        return this.systemInfo;
    }

    public String toString() {
        return "Request [issuedTime=" + this.issuedTime + ", traceId=" + this.traceId + ", sessionId=" + this.sessionId + ", systemInfo=" + this.systemInfo + ", endPoint=" + this.endPoint + "]";
    }
}

