/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.requests.dto;

import java.util.UUID;
import org.piangles.gateway.requests.dto.StatusCode;

public final class Response {
    private long issuedTime = System.currentTimeMillis();
    private long requestTransitTime;
    private long requestProcessingTime;
    private UUID traceId = null;
    private String endpoint = null;
    private StatusCode statusCode = null;
    private boolean requestSuccessful = false;
    private String errorMessage = null;
    private String endpointResponse = null;

    public Response(StatusCode statusCode, String endpointResponse) {
        this(null, null, 0L, 0L, statusCode, endpointResponse);
    }

    public Response(UUID traceId, String endpoint, long requestReceiptTime, long requestTransitTime, StatusCode statusCode, String endpointResponse) {
        this.requestTransitTime = requestTransitTime;
        this.requestProcessingTime = System.currentTimeMillis() - requestReceiptTime;
        this.traceId = traceId;
        this.endpoint = endpoint;
        this.statusCode = statusCode;
        boolean bl = this.requestSuccessful = this.statusCode == StatusCode.Success;
        if (this.requestSuccessful) {
            this.endpointResponse = endpointResponse;
        } else {
            this.errorMessage = endpointResponse;
        }
    }

    public long getIssuedTime() {
        return this.issuedTime;
    }

    public long getRequestTransitTime() {
        return this.requestTransitTime;
    }

    public long getRequestProcessingTime() {
        return this.requestProcessingTime;
    }

    public UUID getTraceId() {
        return this.traceId;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public boolean isRequestSuccessful() {
        return this.requestSuccessful;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getEndpointResponse() {
        return this.endpointResponse;
    }

    public String toString() {
        return "Response [issuedTime=" + this.issuedTime + ", requestTransitTime=" + this.requestTransitTime + ", requestProcessingTime=" + this.requestProcessingTime + ", traceId=" + this.traceId + ", endpoint=" + this.endpoint + ", requestSuccessful=" + this.requestSuccessful + ", statusCode=" + (Object)((Object)this.statusCode) + ", errorMessage=" + this.errorMessage + "]";
    }
}

