/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.requests.processors;

import org.piangles.backbone.services.Locator;
import org.piangles.backbone.services.session.SessionManagementService;
import org.piangles.gateway.CommunicationPattern;
import org.piangles.gateway.client.ClientDetails;
import org.piangles.gateway.requests.Endpoints;
import org.piangles.gateway.requests.dto.EmptyRequest;
import org.piangles.gateway.requests.dto.Request;
import org.piangles.gateway.requests.dto.SimpleResponse;
import org.piangles.gateway.requests.processors.AbstractRequestProcessor;

public final class LogoutRequestProcessor
extends AbstractRequestProcessor<EmptyRequest, SimpleResponse> {
    private SessionManagementService sessionMgmtService = Locator.getInstance().getSessionManagementService();

    public LogoutRequestProcessor() {
        super(Endpoints.Logout, CommunicationPattern.RequestResponse, EmptyRequest.class, SimpleResponse.class);
    }

    @Override
    protected SimpleResponse processRequest(ClientDetails clientDetails, Request request, EmptyRequest emptyRequest) throws Exception {
        this.sessionMgmtService.unregister(clientDetails.getSessionDetails().getUserId(), clientDetails.getSessionDetails().getSessionId());
        return new SimpleResponse(true, "Logged out successfully.");
    }
}

