/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.requests.processors;

import org.piangles.core.util.coding.JSON;
import org.piangles.gateway.CommunicationPattern;
import org.piangles.gateway.client.ClientDetails;
import org.piangles.gateway.events.EventProcessingManager;
import org.piangles.gateway.requests.RequestProcessingThread;
import org.piangles.gateway.requests.RequestProcessor;
import org.piangles.gateway.requests.dto.EmptyRequest;
import org.piangles.gateway.requests.dto.Request;
import org.piangles.gateway.requests.dto.Response;
import org.piangles.gateway.requests.dto.StatusCode;

public abstract class AbstractRequestProcessor<AppReq, AppResp>
implements RequestProcessor {
    private static final String EMPTY_APP_REQUEST_ERR = "App Request cannot be null for this endpoint.";
    private Enum<?> endpoint;
    private CommunicationPattern communicationPattern;
    private Class<AppReq> requestClass = null;
    private Class<AppResp> responseClass = null;

    public AbstractRequestProcessor(Enum<?> endpoint, Class<AppReq> requestClass, Class<AppResp> responseClass) {
        this(endpoint, CommunicationPattern.RequestAsynchronousResponse, requestClass, responseClass);
    }

    public AbstractRequestProcessor(Enum<?> endpoint, CommunicationPattern communicationPattern, Class<AppReq> requestClass, Class<AppResp> responseClass) {
        this.endpoint = endpoint;
        this.communicationPattern = communicationPattern;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public final Response processRequest(ClientDetails clientDetails, Request request) throws Exception {
        Object appRequest = null;
        if (!this.requestClass.equals(EmptyRequest.class) && request.getEndpointRequest() != null) {
            appRequest = JSON.getDecoder().decode(request.getEndpointRequest().getBytes(), this.requestClass);
        }
        Response response = null;
        if (!EmptyRequest.class.equals(this.requestClass) && appRequest == null) {
            response = new Response(request.getTraceId(), request.getEndpoint(), request.getReceiptTime(), request.getTransitTime(), StatusCode.BadRequest, EMPTY_APP_REQUEST_ERR);
        } else {
            AppResp appResponse = this.processRequest(clientDetails, request, appRequest);
            String appResponseAsStr = new String(JSON.getEncoder().encode(appResponse));
            response = new Response(request.getTraceId(), request.getEndpoint(), request.getReceiptTime(), request.getTransitTime(), StatusCode.Success, appResponseAsStr);
        }
        return response;
    }

    @Override
    public final Enum<?> getEndpoint() {
        return this.endpoint;
    }

    @Override
    public final Class<?> getRequestClass() {
        return this.requestClass;
    }

    @Override
    public final Class<?> getResponseClass() {
        return this.responseClass;
    }

    @Override
    public final CommunicationPattern getCommunicationPattern() {
        return this.communicationPattern;
    }

    @Override
    public boolean shouldValidateSession() {
        return true;
    }

    protected final EventProcessingManager getEventProcessingManager() {
        EventProcessingManager npm = null;
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof RequestProcessingThread) {
            npm = ((RequestProcessingThread)((Object)currentThread)).getMessageProcessingManager();
        }
        return npm;
    }

    protected abstract AppResp processRequest(ClientDetails var1, Request var2, AppReq var3) throws Exception;
}

