/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.requests;

import org.apache.commons.lang3.StringUtils;
import org.piangles.backbone.services.Locator;
import org.piangles.backbone.services.logging.LoggingService;
import org.piangles.backbone.services.session.SessionManagementException;
import org.piangles.backbone.services.session.SessionManagementService;
import org.piangles.core.expt.ServiceRuntimeException;
import org.piangles.core.services.remoting.AbstractContextAwareThread;
import org.piangles.core.services.remoting.SessionDetails;
import org.piangles.gateway.client.ClientDetails;
import org.piangles.gateway.events.EventProcessingManager;
import org.piangles.gateway.events.KafkaConsumerManager;
import org.piangles.gateway.requests.RequestProcessor;
import org.piangles.gateway.requests.RequestRouter;
import org.piangles.gateway.requests.ResponseSender;
import org.piangles.gateway.requests.StatusCodeMapper;
import org.piangles.gateway.requests.dao.RequestResponseDetails;
import org.piangles.gateway.requests.dto.Request;
import org.piangles.gateway.requests.dto.Response;
import org.piangles.gateway.requests.dto.StatusCode;
import org.piangles.gateway.requests.hooks.AlertDetails;

public final class RequestProcessingThread
extends AbstractContextAwareThread {
    private static final String INTERNAL_ERR_MESSAGE = "Oh no! Something went wrong on our end. TraceId: %s";
    private ClientDetails clientDetails = null;
    private Request request = null;
    private Response response = null;
    private EventProcessingManager mpm = null;
    private RequestProcessor requestProcessor = null;
    private SessionManagementService sessionMgmtService = Locator.getInstance().getSessionManagementService();
    protected LoggingService logger = Locator.getInstance().getLoggingService();

    public RequestProcessingThread(ClientDetails clientDetails, Request request, RequestProcessor requestProcessor, EventProcessingManager mpm) {
        super.init(clientDetails.getSessionDetails(), request.getTraceId());
        this.clientDetails = clientDetails;
        this.request = request;
        this.requestProcessor = requestProcessor;
        this.mpm = mpm;
    }

    public void run() {
        boolean validSession;
        block15: {
            this.logger.info((Object)("Processing request for Endpoint : " + this.request.getEndpoint()));
            KafkaConsumerManager.getInstance().closeAnyMarked();
            validSession = false;
            if (RequestRouter.getInstance().isPreAuthenticationEndpoint(this.requestProcessor.getEndpoint().name())) {
                validSession = true;
            } else if (this.requestProcessor.shouldValidateSession()) {
                try {
                    validSession = this.sessionMgmtService.isValid(this.clientDetails.getSessionDetails().getUserId(), this.clientDetails.getSessionDetails().getSessionId());
                    if (validSession) {
                        this.sessionMgmtService.makeLastAccessedCurrent(this.clientDetails.getSessionDetails().getUserId(), this.clientDetails.getSessionDetails().getSessionId());
                        this.clientDetails.markLastAccessed();
                        break block15;
                    }
                    this.response = new Response(this.request.getTraceId(), this.request.getEndpoint(), this.request.getReceiptTime(), this.request.getTransitTime(), StatusCode.Unauthenticated, "Invalid sessionId.");
                }
                catch (SessionManagementException e) {
                    String message = "Unable to validate Session because of : " + e.getMessage();
                    this.logger.error((Object)message, (Throwable)e);
                    validSession = false;
                    this.response = new Response(this.request.getTraceId(), this.request.getEndpoint(), this.request.getReceiptTime(), this.request.getTransitTime(), StatusCode.InternalError, this.processInternalErrorMessage(e, message));
                }
            } else if (this.clientDetails.getSessionDetails().getSessionId() != null) {
                validSession = true;
                this.logger.warn((Object)("RequestProcessor for endpoint " + this.requestProcessor.getEndpoint() + " has a sessionId but is coded for not validating session."));
            }
        }
        try {
            if (validSession) {
                this.response = this.requestProcessor.processRequest(this.clientDetails, this.request);
            }
        }
        catch (ServiceRuntimeException e) {
            this.response = this.processServiceRuntimeException(e);
        }
        catch (Exception e) {
            this.logger.warn((Object)("Exception while processing request because of : " + this.extractThrowableMessage(e)), (Throwable)e);
            this.response = new Response(this.getTraceId(), this.request.getEndpoint(), this.request.getReceiptTime(), this.request.getTransitTime(), StatusCode.InternalError, this.processInternalErrorMessage(e, this.extractThrowableMessage(e)));
        }
        catch (Throwable e) {
            this.logger.error((Object)("Unhandled Exception while processing request because of : " + this.extractThrowableMessage(e)), e);
            this.response = new Response(this.getTraceId(), this.request.getEndpoint(), this.request.getReceiptTime(), this.request.getTransitTime(), StatusCode.InternalError, this.processInternalErrorMessage(e, this.extractThrowableMessage(e)));
        }
        ResponseSender.sendResponse(this.clientDetails, this.response);
        try {
            RequestResponseDetails reqRespDetails = new RequestResponseDetails(this.clientDetails, this.request, this.response);
            RequestRouter.getInstance().getGatewayDAO().insertRequestResponseDetails(reqRespDetails);
        }
        catch (Throwable e) {
            this.logger.warn((Object)("IGNORING: Exception while persisting RequestResponseDetails. Reason: " + e.getMessage()), e);
        }
    }

    public Response getResponse() {
        return this.response;
    }

    public EventProcessingManager getMessageProcessingManager() {
        return this.mpm;
    }

    public void setSessionDetails(SessionDetails sessionDetails) {
        super.init(sessionDetails, this.getTraceId());
    }

    private Response processServiceRuntimeException(ServiceRuntimeException sre) {
        Response response = null;
        StatusCode statusCode = StatusCodeMapper.getInstance().getStatusCode(sre);
        String errorMessage = null;
        if (statusCode == null) {
            this.logger.warn((Object)("Unable to find StatusCode for ServiceRuntimeException class " + ((Object)((Object)sre)).getClass().getSimpleName() + " in sreStatusCodeMap, Defaulting to:" + (Object)((Object)StatusCode.InternalError)));
            String message = ((Object)((Object)sre)).getClass().getSimpleName() + " while processing request because of : " + sre.getMessage();
            this.logger.error((Object)message, (Throwable)sre);
            statusCode = StatusCode.InternalError;
            errorMessage = this.processInternalErrorMessage(sre, message);
        } else {
            this.logger.warn((Object)(((Object)((Object)sre)).getClass().getSimpleName() + " while processing request because of : " + sre.getMessage()), (Throwable)sre);
            errorMessage = sre.getMessage();
        }
        response = new Response(this.getTraceId(), this.request.getEndpoint(), this.request.getReceiptTime(), this.request.getTransitTime(), statusCode, errorMessage);
        return response;
    }

    private String processInternalErrorMessage(Throwable throwable, String message) {
        String internalErrorMessage = String.format(INTERNAL_ERR_MESSAGE, this.getTraceId().toString());
        if (RequestRouter.getInstance().getAlertManager() != null) {
            AlertDetails alertDetails = new AlertDetails(this.request.getEndpoint(), this.getTraceId(), throwable, message, this.request.getIssuedTime());
            RequestRouter.getInstance().getAlertManager().process(alertDetails, this.clientDetails);
        }
        return internalErrorMessage;
    }

    private String extractThrowableMessage(Throwable e) {
        String exptMessage = e.getMessage();
        if (StringUtils.isBlank((CharSequence)exptMessage)) {
            exptMessage = e.getClass().getCanonicalName();
        }
        return exptMessage;
    }
}

