/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.client;

import java.net.InetSocketAddress;
import org.piangles.core.services.remoting.SessionDetails;
import org.piangles.gateway.ClientEndpoint;
import org.piangles.gateway.client.Location;

public final class ClientDetails {
    private InetSocketAddress remoteAddress;
    private ClientEndpoint clientEndpoint = null;
    private SessionDetails sessionDetails = null;
    private Location location = null;

    public ClientDetails(InetSocketAddress remoteAddress, ClientEndpoint clientEndpoint, SessionDetails sessionDetails, Location location) {
        this.remoteAddress = remoteAddress;
        this.clientEndpoint = clientEndpoint;
        this.sessionDetails = sessionDetails;
        this.location = location;
    }

    public ClientEndpoint getClientEndpoint() {
        return this.clientEndpoint;
    }

    public SessionDetails getSessionDetails() {
        return this.sessionDetails;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getIPAddress() {
        return this.remoteAddress.getAddress().getHostAddress();
    }

    public String getHostName() {
        return this.remoteAddress.getHostName();
    }

    public int getPort() {
        return this.remoteAddress.getPort();
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public String toString() {
        return "ClientDetails [remoteAddress=" + this.remoteAddress + ", sessionDetails=" + this.sessionDetails + "]";
    }
}

