/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.requests.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.UUID;
import org.piangles.gateway.requests.dto.SystemInfo;

public final class Request {
    @JsonProperty(required=true)
    private long issuedTime = System.currentTimeMillis();
    private long receiptTime;
    private long transitTime;
    @JsonProperty(required=true)
    private UUID traceId = UUID.randomUUID();
    @JsonProperty(required=true)
    private String sessionId = null;
    @JsonProperty(required=true)
    private String endPoint = null;
    @JsonProperty(required=true)
    private String endpointRequest = null;
    @JsonProperty(required=false)
    private SystemInfo systemInfo = null;

    public Request(String sessionId, String endPoint, String endpointRequest, SystemInfo systemInfo) {
        this.sessionId = sessionId;
        this.endPoint = endPoint;
        this.endpointRequest = endpointRequest;
        this.systemInfo = systemInfo;
    }

    public long getIssuedTime() {
        return this.issuedTime;
    }

    public long getReceiptTime() {
        return this.receiptTime;
    }

    public void markTransitTime() {
        this.receiptTime = System.currentTimeMillis();
        this.transitTime = this.receiptTime - this.issuedTime;
    }

    public long getTransitTime() {
        return this.transitTime;
    }

    public UUID getTraceId() {
        return this.traceId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getEndpoint() {
        return this.endPoint;
    }

    public String getEndpointRequest() {
        return this.endpointRequest;
    }

    public SystemInfo getSystemInfo() {
        return this.systemInfo;
    }

    public String toString() {
        return "Request [issuedTime=" + this.issuedTime + ", traceId=" + this.traceId + ", sessionId=" + this.sessionId + ", systemInfo=" + this.systemInfo + ", endPoint=" + this.endPoint + "]";
    }
}

