/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.requests.processors;

import org.piangles.core.util.coding.JSON;
import org.piangles.core.util.validate.ValidationManager;
import org.piangles.core.util.validate.Validator;
import org.piangles.gateway.CommunicationPattern;
import org.piangles.gateway.client.ClientDetails;
import org.piangles.gateway.events.EventProcessingManager;
import org.piangles.gateway.requests.RequestProcessingThread;
import org.piangles.gateway.requests.RequestProcessor;
import org.piangles.gateway.requests.dto.EmptyRequest;
import org.piangles.gateway.requests.dto.Request;
import org.piangles.gateway.requests.dto.Response;
import org.piangles.gateway.requests.dto.StatusCode;

public abstract class AbstractRequestProcessor<EndpointReq, EndpointResp>
implements RequestProcessor {
    private Enum<?> endpoint;
    private CommunicationPattern communicationPattern;
    private Class<EndpointReq> requestClass = null;
    private Class<EndpointResp> responseClass = null;

    public AbstractRequestProcessor(Enum<?> endpoint, Class<EndpointReq> requestClass, Class<EndpointResp> responseClass) {
        this(endpoint, CommunicationPattern.RequestAsynchronousResponse, requestClass, responseClass);
    }

    public AbstractRequestProcessor(Enum<?> endpoint, CommunicationPattern communicationPattern, Class<EndpointReq> requestClass, Class<EndpointResp> responseClass) {
        this.endpoint = endpoint;
        this.communicationPattern = communicationPattern;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public final Response processRequest(ClientDetails clientDetails, Request request) throws Exception {
        Object epRequest = null;
        if (!this.requestClass.equals(EmptyRequest.class) && request.getEndpointRequest() != null) {
            epRequest = JSON.getDecoder().decode(request.getEndpointRequest().getBytes(), this.requestClass);
        }
        Response response = null;
        if (!EmptyRequest.class.equals(this.requestClass) && epRequest == null) {
            response = new Response(request.getTraceId(), request.getEndpoint(), request.getReceiptTime(), request.getTransitTime(), StatusCode.BadRequest, "EndpointRequest cannot be null for this endpoint.");
        } else {
            Validator validator = ValidationManager.getInstance().getValidator(request.getEndpoint());
            if (validator != null) {
                validator.validate(new Object[]{clientDetails, request, epRequest});
            }
            EndpointResp epResponse = this.processRequest(clientDetails, request, epRequest);
            String epResponseAsStr = new String(JSON.getEncoder().encode(epResponse));
            response = new Response(request.getTraceId(), request.getEndpoint(), request.getReceiptTime(), request.getTransitTime(), StatusCode.Success, epResponseAsStr);
        }
        return response;
    }

    @Override
    public final Enum<?> getEndpoint() {
        return this.endpoint;
    }

    @Override
    public final Class<?> getRequestClass() {
        return this.requestClass;
    }

    @Override
    public final Class<?> getResponseClass() {
        return this.responseClass;
    }

    @Override
    public final CommunicationPattern getCommunicationPattern() {
        return this.communicationPattern;
    }

    @Override
    public boolean shouldValidateSession() {
        return true;
    }

    protected final EventProcessingManager getEventProcessingManager() {
        EventProcessingManager npm = null;
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof RequestProcessingThread) {
            npm = ((RequestProcessingThread)((Object)currentThread)).getMessageProcessingManager();
        }
        return npm;
    }

    protected abstract EndpointResp processRequest(ClientDetails var1, Request var2, EndpointReq var3) throws Exception;
}

