/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.requests.processors;

import org.piangles.backbone.services.Locator;
import org.piangles.backbone.services.auth.AuthenticationResponse;
import org.piangles.backbone.services.auth.AuthenticationService;
import org.piangles.gateway.CommunicationPattern;
import org.piangles.gateway.client.ClientDetails;
import org.piangles.gateway.requests.Endpoints;
import org.piangles.gateway.requests.dto.GenerateTokenRequest;
import org.piangles.gateway.requests.dto.Request;
import org.piangles.gateway.requests.dto.SimpleResponse;
import org.piangles.gateway.requests.processors.AbstractRequestProcessor;

public final class GenerateTokenRequestProcessor
extends AbstractRequestProcessor<GenerateTokenRequest, SimpleResponse> {
    private AuthenticationService authService = Locator.getInstance().getAuthenticationService();

    public GenerateTokenRequestProcessor() {
        super(Endpoints.GenerateResetToken, CommunicationPattern.RequestResponse, GenerateTokenRequest.class, SimpleResponse.class);
    }

    @Override
    protected SimpleResponse processRequest(ClientDetails clientDetails, Request request, GenerateTokenRequest tokenRequest) throws Exception {
        boolean result = true;
        String message = "Please check your registered email for the token.";
        AuthenticationResponse response = this.authService.generateResetToken(tokenRequest.getEmailId());
        result = response.isRequestSuccessful();
        if (!result) {
            message = "Could not generate a reset token.";
        }
        return new SimpleResponse(result, message);
    }

    @Override
    public boolean shouldValidateSession() {
        return false;
    }
}

