/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.requests.processors;

import org.piangles.backbone.services.Locator;
import org.piangles.backbone.services.geo.GeoLocation;
import org.piangles.backbone.services.geo.GeoLocationService;
import org.piangles.gateway.client.ClientDetails;
import org.piangles.gateway.client.Location;
import org.piangles.gateway.requests.Endpoints;
import org.piangles.gateway.requests.dto.LocationRequest;
import org.piangles.gateway.requests.dto.Request;
import org.piangles.gateway.requests.dto.SimpleResponse;
import org.piangles.gateway.requests.processors.AbstractRequestProcessor;

public class SetLocationRequestProcessor
extends AbstractRequestProcessor<LocationRequest, SimpleResponse> {
    private static final SimpleResponse INVALID_REQUEST = new SimpleResponse(false, "LocationRequest received is not a valid or does not have valid values.");
    private GeoLocationService geolocationService = Locator.getInstance().getGeoLocationService();

    public SetLocationRequestProcessor() {
        super(Endpoints.SetLocation, LocationRequest.class, SimpleResponse.class);
    }

    @Override
    protected SimpleResponse processRequest(ClientDetails clientDetails, Request request, LocationRequest locationRequest) throws Exception {
        SimpleResponse simpleResponse = null;
        GeoLocation geoLocation = null;
        boolean precise = true;
        if (!(locationRequest.getLocation() != null && !this.geolocationService.isValid(locationRequest.getLocation().convert()) || locationRequest.getPhysicalAddress() != null && !locationRequest.getPhysicalAddress().isValid() || locationRequest.getZipCode() != null && locationRequest.getZipCode().isValid())) {
            simpleResponse = INVALID_REQUEST;
        } else {
            String fromName = null;
            if (locationRequest.getLocation() != null) {
                fromName = "Location";
                geoLocation = locationRequest.getLocation().convert();
            } else if (locationRequest.getPhysicalAddress() != null) {
                fromName = "PhysicalAddress";
                geoLocation = this.geolocationService.getGeoLocation(locationRequest.getPhysicalAddress());
            } else {
                fromName = "ZipCode";
                geoLocation = this.geolocationService.getGeoLocation(locationRequest.getZipCode());
                precise = false;
            }
            if (geoLocation != null) {
                clientDetails.setLocation(Location.convert(geoLocation, precise));
                simpleResponse = new SimpleResponse(true);
            } else {
                simpleResponse = new SimpleResponse(false, String.format("Unable to determine GeoLocation from %s .", fromName));
            }
        }
        return simpleResponse;
    }
}

