/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.requests.processors;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.piangles.backbone.services.Locator;
import org.piangles.backbone.services.msg.MessagingService;
import org.piangles.backbone.services.msg.Topic;
import org.piangles.gateway.client.ClientDetails;
import org.piangles.gateway.requests.Endpoints;
import org.piangles.gateway.requests.dto.Request;
import org.piangles.gateway.requests.dto.SimpleResponse;
import org.piangles.gateway.requests.dto.SubscriptionRequest;
import org.piangles.gateway.requests.processors.AbstractRequestProcessor;

public class SubscriptionRequestProcessor
extends AbstractRequestProcessor<SubscriptionRequest, SimpleResponse> {
    private static final String ENTITY_ALIAS = "Entity";
    private MessagingService msgService = Locator.getInstance().getMessagingService();

    public SubscriptionRequestProcessor() {
        super(Endpoints.Subscribe, SubscriptionRequest.class, SimpleResponse.class);
    }

    @Override
    public final SimpleResponse processRequest(ClientDetails clientDetails, Request request, SubscriptionRequest subscribeRequest) throws Exception {
        boolean result = true;
        String message = "Subscription was successful.";
        List topics = null;
        String alias = subscribeRequest.getTopicAlias();
        boolean entityRelated = false;
        if (subscribeRequest.getTopicAlias().startsWith(ENTITY_ALIAS)) {
            entityRelated = true;
            alias = subscribeRequest.getTopicAlias().substring(ENTITY_ALIAS.length());
        }
        if (entityRelated) {
            topics = this.msgService.getTopicsFor(alias, subscribeRequest.getId());
            if (topics == null) {
                result = false;
                message = "Entity " + alias + " does not have any associated topics.";
            }
        } else {
            topics = this.msgService.getTopicsForAlias(alias);
            if (topics == null) {
                result = false;
                message = "Alias does not have any associated topics.";
            }
        }
        if (topics != null) {
            HashMap<Topic, UUID> topicTraceIdMap = new HashMap<Topic, UUID>();
            topics.stream().forEach(topic -> topicTraceIdMap.put((Topic)topic, request.getTraceId()));
            this.getEventProcessingManager().subscribeToTopics(topicTraceIdMap);
            this.getEventProcessingManager().restart();
        }
        return new SimpleResponse(result, message);
    }
}

