/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.requests.processors;

import org.piangles.backbone.services.Locator;
import org.piangles.backbone.services.auth.AuthenticationResponse;
import org.piangles.backbone.services.auth.AuthenticationService;
import org.piangles.backbone.services.auth.AuthenticationType;
import org.piangles.backbone.services.auth.Credential;
import org.piangles.backbone.services.auth.FailureReason;
import org.piangles.backbone.services.session.SessionDetails;
import org.piangles.backbone.services.session.SessionManagementService;
import org.piangles.gateway.CommunicationPattern;
import org.piangles.gateway.client.ClientDetails;
import org.piangles.gateway.requests.Endpoints;
import org.piangles.gateway.requests.dto.LoginRequest;
import org.piangles.gateway.requests.dto.LoginResponse;
import org.piangles.gateway.requests.dto.Request;
import org.piangles.gateway.requests.processors.AbstractRequestProcessor;

public final class LoginRequestProcessor
extends AbstractRequestProcessor<LoginRequest, LoginResponse> {
    private SessionManagementService sessionMgmtService = Locator.getInstance().getSessionManagementService();
    private AuthenticationService authService = Locator.getInstance().getAuthenticationService();

    public LoginRequestProcessor() {
        super(Endpoints.Login, CommunicationPattern.RequestResponse, LoginRequest.class, LoginResponse.class);
    }

    @Override
    protected LoginResponse processRequest(ClientDetails clientDetails, Request request, LoginRequest loginRequest) throws Exception {
        LoginResponse loginResponse = null;
        if (loginRequest.getPassword() != null) {
            AuthenticationType type = AuthenticationType.valueOf((String)loginRequest.getAuthenticationType());
            AuthenticationResponse authResponse = this.authService.authenticate(type, new Credential(loginRequest.getId(), loginRequest.getPassword()));
            if (authResponse.isAuthenticated()) {
                SessionDetails sessionDetails = this.sessionMgmtService.register(authResponse.getUserId());
                loginResponse = new LoginResponse(authResponse.getUserId(), sessionDetails.getSessionId(), authResponse.IsValidatedByToken());
            } else {
                loginResponse = new LoginResponse(authResponse.getNoOfAttemptsRemaining(), authResponse.getFailureReason());
            }
        } else {
            boolean isSessionValid = this.sessionMgmtService.isValid(loginRequest.getId(), loginRequest.getSessionId());
            if (isSessionValid) {
                this.sessionMgmtService.makeLastAccessedCurrent(loginRequest.getId(), loginRequest.getSessionId());
                loginResponse = new LoginResponse(loginRequest.getId(), loginRequest.getSessionId(), false);
            } else {
                loginResponse = new LoginResponse(0, FailureReason.InvalidSession);
            }
        }
        return loginResponse;
    }

    @Override
    public boolean shouldValidateSession() {
        return false;
    }
}

