/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.requests;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.piangles.backbone.services.Locator;
import org.piangles.backbone.services.logging.LoggingService;
import org.piangles.backbone.services.session.SessionManagementException;
import org.piangles.backbone.services.session.SessionManagementService;
import org.piangles.core.expt.BadRequestException;
import org.piangles.core.expt.NotFoundException;
import org.piangles.core.expt.PayloadTooLargeException;
import org.piangles.core.expt.RequestedFormatNotSupportedException;
import org.piangles.core.expt.ServiceRuntimeException;
import org.piangles.core.expt.UnauthenticatedException;
import org.piangles.core.expt.UnauthorizedException;
import org.piangles.core.expt.UnsupportedMediaException;
import org.piangles.core.expt.ValidationException;
import org.piangles.core.expt.VersionMismatchException;
import org.piangles.core.services.remoting.AbstractContextAwareThread;
import org.piangles.core.services.remoting.SessionDetails;
import org.piangles.gateway.client.ClientDetails;
import org.piangles.gateway.events.EventProcessingManager;
import org.piangles.gateway.events.KafkaConsumerManager;
import org.piangles.gateway.requests.RequestProcessor;
import org.piangles.gateway.requests.RequestRouter;
import org.piangles.gateway.requests.ResponseSender;
import org.piangles.gateway.requests.dto.Request;
import org.piangles.gateway.requests.dto.Response;
import org.piangles.gateway.requests.dto.StatusCode;

public final class RequestProcessingThread
extends AbstractContextAwareThread {
    private static final String INTERNAL_ERR_MESSAGE = "Oh no! Something went wrong on our end. TraceId: %s";
    private ClientDetails clientDetails = null;
    private Request request = null;
    private Response response = null;
    private EventProcessingManager mpm = null;
    private RequestProcessor requestProcessor = null;
    private SessionManagementService sessionMgmtService = Locator.getInstance().getSessionManagementService();
    protected LoggingService logger = Locator.getInstance().getLoggingService();
    private Map<String, StatusCode> sreStatusCodeMap = null;

    public RequestProcessingThread(ClientDetails clientDetails, Request request, RequestProcessor requestProcessor, EventProcessingManager mpm) {
        super.init(clientDetails.getSessionDetails(), request.getTraceId());
        this.clientDetails = clientDetails;
        this.request = request;
        this.requestProcessor = requestProcessor;
        this.mpm = mpm;
        this.sreStatusCodeMap = new HashMap<String, StatusCode>();
        this.sreStatusCodeMap.put(BadRequestException.class.getSimpleName(), StatusCode.BadRequest);
        this.sreStatusCodeMap.put(NotFoundException.class.getSimpleName(), StatusCode.NotFound);
        this.sreStatusCodeMap.put(PayloadTooLargeException.class.getSimpleName(), StatusCode.PayloadTooLarge);
        this.sreStatusCodeMap.put(RequestedFormatNotSupportedException.class.getSimpleName(), StatusCode.RequestedFormatNotSupported);
        this.sreStatusCodeMap.put(UnauthenticatedException.class.getSimpleName(), StatusCode.Unauthenticated);
        this.sreStatusCodeMap.put(UnauthorizedException.class.getSimpleName(), StatusCode.Unauthorized);
        this.sreStatusCodeMap.put(UnsupportedMediaException.class.getSimpleName(), StatusCode.UnsupportedMedia);
        this.sreStatusCodeMap.put(ValidationException.class.getSimpleName(), StatusCode.ValidationFailure);
        this.sreStatusCodeMap.put(VersionMismatchException.class.getSimpleName(), StatusCode.VersionMismatch);
    }

    public void run() {
        boolean validSession;
        block13: {
            this.logger.info((Object)("Processing request for Endpoint : " + this.request.getEndpoint()));
            KafkaConsumerManager.getInstance().closeAnyMarked();
            validSession = false;
            if (RequestRouter.getInstance().isPreAuthenticationEndpoint(this.requestProcessor.getEndpoint().name())) {
                validSession = true;
            } else if (this.requestProcessor.shouldValidateSession()) {
                try {
                    validSession = this.sessionMgmtService.isValid(this.clientDetails.getSessionDetails().getUserId(), this.clientDetails.getSessionDetails().getSessionId());
                    if (validSession) {
                        this.sessionMgmtService.makeLastAccessedCurrent(this.clientDetails.getSessionDetails().getUserId(), this.clientDetails.getSessionDetails().getSessionId());
                        break block13;
                    }
                    this.response = new Response(this.request.getTraceId(), this.request.getEndpoint(), this.request.getReceiptTime(), this.request.getTransitTime(), StatusCode.Unauthenticated, "Invalid sessionId.");
                }
                catch (SessionManagementException e) {
                    this.logger.error((Object)("Unable to validate Session because of : " + e.getMessage()), (Throwable)e);
                    validSession = false;
                    this.response = new Response(this.request.getTraceId(), this.request.getEndpoint(), this.request.getReceiptTime(), this.request.getTransitTime(), StatusCode.InternalError, this.internalErrorMessage());
                }
            } else if (this.clientDetails.getSessionDetails().getSessionId() != null) {
                validSession = true;
                this.logger.warn((Object)("RequestProcessor for endpoint " + this.requestProcessor.getEndpoint() + " has a sessionId but is coded for not validating session."));
            }
        }
        try {
            if (validSession) {
                this.response = this.requestProcessor.processRequest(this.clientDetails, this.request);
            }
        }
        catch (ServiceRuntimeException e) {
            this.response = this.processServiceRuntimeException(e);
        }
        catch (Exception e) {
            this.logger.warn((Object)("Exception while processing request because of : " + this.extractThrowableMessage(e)), (Throwable)e);
            this.response = new Response(this.getTraceId(), this.request.getEndpoint(), this.request.getReceiptTime(), this.request.getTransitTime(), StatusCode.InternalError, this.internalErrorMessage());
        }
        catch (Throwable e) {
            this.logger.error((Object)("Unhandled Exception while processing request because of : " + this.extractThrowableMessage(e)), e);
            this.response = new Response(this.getTraceId(), this.request.getEndpoint(), this.request.getReceiptTime(), this.request.getTransitTime(), StatusCode.InternalError, this.internalErrorMessage());
        }
        ResponseSender.sendResponse(this.clientDetails, this.response);
    }

    public Response getResponse() {
        return this.response;
    }

    public EventProcessingManager getMessageProcessingManager() {
        return this.mpm;
    }

    public void setSessionDetails(SessionDetails sessionDetails) {
        super.init(sessionDetails, this.getTraceId());
    }

    private Response processServiceRuntimeException(ServiceRuntimeException sre) {
        Response response = null;
        StatusCode statusCode = this.sreStatusCodeMap.get(((Object)((Object)sre)).getClass().getSimpleName());
        String errorMessage = null;
        if (statusCode == null) {
            this.logger.warn((Object)("Unable to find StatusCode for ServiceRuntimeException class " + ((Object)((Object)sre)).getClass().getSimpleName() + " in sreStatusCodeMap, Defaulting to:" + (Object)((Object)StatusCode.InternalError)));
            this.logger.error((Object)(((Object)((Object)sre)).getClass().getSimpleName() + " while processing request because of : " + sre.getMessage()), (Throwable)sre);
            statusCode = StatusCode.InternalError;
            errorMessage = this.internalErrorMessage();
        } else {
            this.logger.warn((Object)(((Object)((Object)sre)).getClass().getSimpleName() + " while processing request because of : " + sre.getMessage()), (Throwable)sre);
            errorMessage = sre.getMessage();
        }
        response = new Response(this.getTraceId(), this.request.getEndpoint(), this.request.getReceiptTime(), this.request.getTransitTime(), statusCode, errorMessage);
        return response;
    }

    private String internalErrorMessage() {
        return String.format(INTERNAL_ERR_MESSAGE, this.getTraceId().toString());
    }

    private String extractThrowableMessage(Throwable e) {
        String exptMessage = e.getMessage();
        if (StringUtils.isBlank((CharSequence)exptMessage)) {
            exptMessage = e.getClass().getCanonicalName();
        }
        return exptMessage;
    }
}

