/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.service.impl.jetty;

import java.util.EnumSet;
import java.util.Set;
import javax.servlet.DispatcherType;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.http.pathmap.ServletPathSpec;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.websocket.server.WebSocketUpgradeFilter;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.piangles.backbone.services.Locator;
import org.piangles.backbone.services.logging.LoggingService;
import org.piangles.core.services.remoting.SessionAwareable;
import org.piangles.core.services.remoting.SessionDetails;
import org.piangles.core.services.remoting.SessionDetailsCreator;
import org.piangles.gateway.GatewayService;
import org.piangles.gateway.requests.RequestRouter;
import org.piangles.gateway.service.impl.jetty.WebSocketLifecycleEventHandler;

public class GatewayServiceImpl
implements GatewayService {
    private static final String GATEWAY_METADATA_ENABLED = "gateway.metadata.enabled";
    private LoggingService logger = Locator.getInstance().getLoggingService();
    private Server server = new Server((ThreadPool)new GatewayThreadPool());

    @Override
    public void init(String host, int port) throws Exception {
        ServerConnector connector = new ServerConnector(this.server);
        connector.setHost(host);
        connector.setPort(port);
        this.server.addConnector((Connector)connector);
        ServletContextHandler defaultContext = new ServletContextHandler();
        defaultContext.setContextPath("/");
        String welcomePage = null;
        String apiMetadataEnabled = System.getenv(GATEWAY_METADATA_ENABLED);
        welcomePage = Boolean.parseBoolean(apiMetadataEnabled) ? "index.html" : "emptyIndex.html";
        this.logger.info((Object)("APIMetadataEnabled: " + apiMetadataEnabled + " WelcomePage: " + welcomePage));
        defaultContext.setWelcomeFiles(new String[]{welcomePage});
        String path = this.getClass().getClassLoader().getResource("web").toExternalForm();
        defaultContext.setResourceBase(path);
        defaultContext.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        defaultContext.addServlet(DefaultServlet.class, "/");
        FilterHolder cors = defaultContext.addFilter(CrossOriginFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        cors.setInitParameter("allowedOrigins", "*");
        cors.setInitParameter("Access-Control-Allow-Origin", "*");
        cors.setInitParameter("allowedMethods", "GET,POST,HEAD");
        cors.setInitParameter("allowedHeaders", "X-Requested-With,Content-Type,Accept,Origin");
        WebSocketUpgradeFilter wsfilter = WebSocketUpgradeFilter.configure((ServletContextHandler)defaultContext);
        wsfilter.addMapping((PathSpec)new ServletPathSpec("/api/"), (WebSocketCreator)new WebSocketCreatorImpl());
        this.server.setHandler((Handler)defaultContext);
    }

    @Override
    public void startProcessingRequests() throws Exception {
        System.out.println("GatewayService is being started...");
        this.logger.info((Object)"GatewayService is being started...");
        Set<String> endpoints = RequestRouter.getInstance().getRegisteredEndpoints();
        for (String endpoint : endpoints) {
            System.out.println("Registered endpoint : " + endpoint);
            this.logger.info((Object)("Registered endpoint : " + endpoint));
        }
        this.server.start();
        this.server.dump((Appendable)System.err);
        System.out.println("GatewayService has started and is ready to process requests.");
        this.logger.info((Object)"GatewayService has started and is ready to process requests.");
        this.server.join();
    }

    class ClientHandlerThread
    extends Thread
    implements SessionAwareable {
        private Runnable runnable = null;
        private SessionDetails sessionDetails = null;

        public ClientHandlerThread(Runnable runnable) {
            this.runnable = runnable;
            try {
                this.sessionDetails = SessionDetailsCreator.createSessionDetails((String)"GatewayService");
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw new RuntimeException(e);
            }
        }

        @Override
        public void run() {
            this.runnable.run();
        }

        public SessionDetails getSessionDetails() {
            return this.sessionDetails;
        }
    }

    class WebSocketCreatorImpl
    implements WebSocketCreator {
        WebSocketCreatorImpl() {
        }

        public Object createWebSocket(ServletUpgradeRequest req, ServletUpgradeResponse resp) {
            return new WebSocketLifecycleEventHandler();
        }
    }

    class GatewayThreadPool
    extends QueuedThreadPool {
        GatewayThreadPool() {
        }

        public Thread newThread(Runnable runnable) {
            return new ClientHandlerThread(runnable);
        }
    }
}

