/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.service.impl.jetty;

import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.piangles.core.util.Logger;
import org.piangles.gateway.requests.RequestProcessingManager;
import org.piangles.gateway.service.impl.jetty.ClientEndpointImpl;

@WebSocket
public final class WebSocketLifecycleEventHandler {
    private RequestProcessingManager rpm = null;

    @OnWebSocketClose
    public void onClose(int statusCode, String reason) {
        this.rpm.onClose(statusCode, reason);
    }

    @OnWebSocketError
    public void onError(Throwable t) {
        this.rpm.onError(t);
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
        try {
            session.setIdleTimeout(120000L);
            session.getPolicy().setMaxTextMessageSize(327680);
            this.rpm = new RequestProcessingManager(session.getRemoteAddress(), new ClientEndpointImpl(session));
        }
        catch (Throwable t) {
            Logger.getInstance().error((Object)("Exception while creating RequestProcessingManager: " + t.getMessage()), t);
            t.printStackTrace();
            t.printStackTrace(System.out);
        }
    }

    @OnWebSocketMessage
    public void onMessage(String message) {
        this.rpm.onMessage(message);
    }
}

