/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.requests;

import java.net.InetSocketAddress;
import org.apache.commons.lang3.StringUtils;
import org.piangles.backbone.services.Locator;
import org.piangles.backbone.services.logging.LoggingService;
import org.piangles.backbone.services.session.SessionManagementException;
import org.piangles.backbone.services.session.SessionManagementService;
import org.piangles.core.expt.BadRequestException;
import org.piangles.core.resources.ResourceException;
import org.piangles.core.services.remoting.SessionDetails;
import org.piangles.core.util.coding.JSON;
import org.piangles.gateway.ClientEndpoint;
import org.piangles.gateway.CommunicationPattern;
import org.piangles.gateway.Message;
import org.piangles.gateway.client.ClientDetails;
import org.piangles.gateway.client.ClientState;
import org.piangles.gateway.events.EventProcessingManager;
import org.piangles.gateway.requests.Endpoints;
import org.piangles.gateway.requests.RequestProcessingThread;
import org.piangles.gateway.requests.RequestProcessor;
import org.piangles.gateway.requests.RequestRouter;
import org.piangles.gateway.requests.ResponseSender;
import org.piangles.gateway.requests.dto.AuthenticationDetails;
import org.piangles.gateway.requests.dto.Ping;
import org.piangles.gateway.requests.dto.Pong;
import org.piangles.gateway.requests.dto.Request;
import org.piangles.gateway.requests.dto.Response;
import org.piangles.gateway.requests.dto.StatusCode;

public final class RequestProcessingManager {
    private LoggingService logger = null;
    private SessionManagementService sessionService = null;
    private ClientState state = ClientState.PreAuthentication;
    private ClientDetails clientDetails = null;
    private EventProcessingManager epm = null;

    public RequestProcessingManager(InetSocketAddress remoteAddr, ClientEndpoint clientEndpoint) {
        this.logger = Locator.getInstance().getLoggingService();
        this.sessionService = Locator.getInstance().getSessionManagementService();
        String userId = remoteAddr.getAddress().getHostName() + ":" + remoteAddr.getPort();
        this.clientDetails = new ClientDetails(remoteAddr, clientEndpoint, new SessionDetails(userId, null), 0L, 0L, null);
        this.logger.info((Object)String.format("New connection from : [Host=%s & Port=%d ]", this.clientDetails.getHostName(), this.clientDetails.getPort()));
    }

    public void onClose(int statusCode, String reason) {
        this.logger.info((Object)String.format("Close received for UserId=%s with StatusCode=%d and Reason=%s", this.clientDetails.getSessionDetails().getUserId(), statusCode, reason));
        try {
            this.sessionService.markForUnregister(this.clientDetails.getSessionDetails().getUserId(), this.clientDetails.getSessionDetails().getSessionId());
        }
        catch (SessionManagementException e) {
            this.logger.error((Object)("Unable to markForUnregister Session for UserId:" + this.clientDetails.getSessionDetails().getUserId()), (Throwable)e);
        }
        if (this.epm != null) {
            this.epm.stop();
        }
    }

    public void onError(Throwable t) {
        this.logger.error((Object)String.format("Error received for UserId=%s with Message=%s", this.clientDetails.getSessionDetails().getUserId(), t.getMessage()), t);
        try {
            this.sessionService.markForUnregister(this.clientDetails.getSessionDetails().getUserId(), this.clientDetails.getSessionDetails().getSessionId());
        }
        catch (SessionManagementException e) {
            this.logger.error((Object)("Unable to markForUnregister Session for UserId:" + this.clientDetails.getSessionDetails().getUserId()), (Throwable)e);
        }
        if (this.epm != null) {
            this.epm.stop();
        }
    }

    public void onMessage(String messageAsString) {
        Message message = null;
        Request request = null;
        Response response = null;
        this.logger.info((Object)("Message receieved from userId : " + this.clientDetails.getSessionDetails().getUserId()));
        String endpoint = null;
        RequestProcessor requestProcessor = null;
        try {
            this.logger.info((Object)("Message receieved from userId : " + this.clientDetails.getSessionDetails().getUserId()));
            if (StringUtils.isBlank((CharSequence)messageAsString)) {
                throw new BadRequestException("GatewayMessage cannot be empty.");
            }
            message = (Message)JSON.getDecoder().decode(messageAsString.getBytes(), Message.class);
            if (StringUtils.isBlank((CharSequence)message.getPayload())) {
                throw new BadRequestException("GatewayMessage Payload cannot be empty.");
            }
            request = (Request)JSON.getDecoder().decode(message.getPayload().getBytes(), Request.class);
            request.markTransitTime();
            endpoint = request.getEndpoint();
            requestProcessor = RequestRouter.getInstance().getRequestProcessor(endpoint);
            if (requestProcessor == null && !Endpoints.Ping.name().equals(endpoint)) {
                String errorMessage = "This endpoint " + request.getEndpoint() + " is not supported.";
                this.logger.warn((Object)errorMessage);
                response = new Response(request.getTraceId(), request.getEndpoint(), request.getReceiptTime(), request.getTransitTime(), StatusCode.NotFound, errorMessage);
            } else {
                response = this.validateRequestAgainstState(request, requestProcessor);
                if (response == null) {
                    if (Endpoints.Ping.name().equals(endpoint)) {
                        if (this.clientDetails.hasSessionExpired()) {
                            this.logger.info((Object)("Ping Received from User: " + this.clientDetails.getSessionDetails().getUserId() + " but session has expired. Closing connection."));
                            this.clientDetails.getClientEndpoint().close();
                        } else {
                            Ping ping = (Ping)JSON.getDecoder().decode(request.getEndpointRequest().getBytes(), Ping.class);
                            Pong pong = new Pong(ping.getSequenceNo(), ping.getTimestamp());
                            String epResponseAsStr = new String(JSON.getEncoder().encode((Object)pong));
                            response = new Response(request.getTraceId(), request.getEndpoint(), request.getReceiptTime(), request.getTransitTime(), StatusCode.Success, epResponseAsStr);
                        }
                    } else {
                        this.processRequestAndSendResponse(request, requestProcessor);
                    }
                }
            }
        }
        catch (InterruptedException e) {
            this.logger.error((Object)("Error in RequestProcessingThread because of : " + e.getMessage()), (Throwable)e);
            response = new Response(request.getTraceId(), request.getEndpoint(), request.getReceiptTime(), request.getTransitTime(), StatusCode.InternalError, "Could not process request because of Internal Error.");
        }
        catch (ResourceException e) {
            this.logger.error((Object)("EventProcessingManager Creation Failed: " + this.clientDetails.getSessionDetails().getUserId()), (Throwable)e);
            response = new Response(request.getTraceId(), request.getEndpoint(), request.getReceiptTime(), request.getTransitTime(), StatusCode.InternalError, e.getMessage());
        }
        catch (Exception e) {
            this.logger.warn((Object)("Message receieved from userId : " + this.clientDetails.getSessionDetails().getUserId() + " could not be decoded."), (Throwable)e);
            response = new Response(StatusCode.BadRequest, "Request could not be decoded because of : " + e.getMessage());
        }
        if (response != null) {
            ResponseSender.sendResponse(this.clientDetails, response);
        }
    }

    private Response validateRequestAgainstState(Request request, RequestProcessor requestProcessor) {
        Response response = null;
        if (this.state == ClientState.PreAuthentication && !RequestRouter.getInstance().isPreAuthenticationEndpoint(request.getEndpoint())) {
            String errorMessage = "This endpoint " + request.getEndpoint() + " requires authentication.";
            this.logger.warn((Object)errorMessage);
            response = new Response(request.getTraceId(), request.getEndpoint(), request.getReceiptTime(), request.getTransitTime(), StatusCode.Unauthenticated, errorMessage);
        } else if (this.state == ClientState.MidAuthentication && !Endpoints.ChangePassword.name().equals(request.getEndpoint())) {
            String errorMessage = "This endpoint " + request.getEndpoint() + " requires password to be updated.";
            this.logger.warn((Object)errorMessage);
            response = new Response(request.getTraceId(), request.getEndpoint(), request.getReceiptTime(), request.getTransitTime(), StatusCode.ValidationFailure, errorMessage);
        } else if (!(this.state == ClientState.PreAuthentication && RequestRouter.getInstance().isPreAuthenticationEndpoint(request.getEndpoint()) || this.clientDetails.getSessionDetails() == null || StringUtils.equals((CharSequence)this.clientDetails.getSessionDetails().getSessionId(), (CharSequence)request.getSessionId()))) {
            String errorMessage = "SessionId between client and server does not match.";
            this.logger.warn((Object)(errorMessage + " SessionIds ClientDetails[" + this.clientDetails.getSessionDetails().getSessionId() + "] Request[" + request.getSessionId() + "]"));
            response = new Response(request.getTraceId(), request.getEndpoint(), request.getReceiptTime(), request.getTransitTime(), StatusCode.Unauthenticated, errorMessage);
        }
        return response;
    }

    private void processRequestAndSendResponse(Request request, RequestProcessor requestProcessor) throws Exception {
        boolean asyncProcessor;
        boolean bl = asyncProcessor = !CommunicationPattern.RequestResponse.equals((Object)requestProcessor.getCommunicationPattern());
        if (asyncProcessor) {
            this.processRequestASynchronously(request);
        } else {
            Response response = this.processRequestSynchronously(request);
            this.performPostSynchronousRequestProcessingActions(request, response);
        }
    }

    private Response processRequestSynchronously(Request request) throws InterruptedException {
        RequestProcessingThread reqProcThread = this.processRequestASynchronously(request);
        reqProcThread.join();
        return reqProcThread.getResponse();
    }

    private RequestProcessingThread processRequestASynchronously(Request request) {
        RequestProcessor rp = RequestRouter.getInstance().getRequestProcessor(request.getEndpoint());
        RequestProcessingThread reqProcThread = new RequestProcessingThread(this.clientDetails, request, rp, this.epm);
        reqProcThread.start();
        return reqProcThread;
    }

    private void performPostSynchronousRequestProcessingActions(Request request, Response response) throws ResourceException, Exception {
        switch (this.state) {
            case PreAuthentication: {
                AuthenticationDetails authDetails;
                if (!RequestRouter.getInstance().isAuthenticationEndpoint(request.getEndpoint()) || !response.isRequestSuccessful() || !(authDetails = (AuthenticationDetails)JSON.getDecoder().decode(response.getEndpointResponse().getBytes(), AuthenticationDetails.class)).isAuthenticated()) break;
                this.state = authDetails.isAuthenticatedByToken() ? ClientState.MidAuthentication : ClientState.PostAuthentication;
                this.clientDetails = new ClientDetails(this.clientDetails.getRemoteAddress(), this.clientDetails.getClientEndpoint(), new SessionDetails(authDetails.getUserId(), authDetails.getSessionId()), authDetails.getInactivityExpiryTimeInSeconds(), authDetails.getLastLoggedInTimestamp(), null);
                this.clientDetails.markLastAccessed();
                this.logger.info((Object)("Creating EventProcessingManager for: " + this.clientDetails));
                this.epm = new EventProcessingManager(this.clientDetails);
                break;
            }
            case MidAuthentication: {
                if (!Endpoints.ChangePassword.name().equals(request.getEndpoint()) || !response.isRequestSuccessful()) break;
                this.logger.info((Object)("ChangePassword was successful moving to PostAuthentication state for: " + this.clientDetails));
                this.state = ClientState.PostAuthentication;
                break;
            }
            case PostAuthentication: {
                if (!request.getEndpoint().equals("Logout")) break;
                this.state = ClientState.PreAuthentication;
                this.clientDetails.getClientEndpoint().close();
            }
        }
    }
}

