/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.requests.processors;

import org.piangles.backbone.services.Locator;
import org.piangles.backbone.services.profile.BasicUserProfile;
import org.piangles.backbone.services.profile.UserProfileService;
import org.piangles.gateway.client.ClientDetails;
import org.piangles.gateway.requests.Endpoints;
import org.piangles.gateway.requests.dto.BooleanResponse;
import org.piangles.gateway.requests.dto.Request;
import org.piangles.gateway.requests.dto.UserProfileExistsRequest;
import org.piangles.gateway.requests.processors.AbstractRequestProcessor;
import software.amazon.awssdk.utils.StringUtils;

public class UserProfileExistsRequestProcessor
extends AbstractRequestProcessor<UserProfileExistsRequest, BooleanResponse> {
    private UserProfileService profileService = Locator.getInstance().getUserProfileService();

    public UserProfileExistsRequestProcessor() {
        super(Endpoints.UserProfileExists, UserProfileExistsRequest.class, BooleanResponse.class);
    }

    @Override
    protected BooleanResponse processRequest(ClientDetails clientDetails, Request request, UserProfileExistsRequest userProfileExistsRequest) throws Exception {
        BooleanResponse response = null;
        String userId = this.profileService.searchProfile(new BasicUserProfile(null, null, userProfileExistsRequest.getEmailId(), userProfileExistsRequest.getPhoneNo()));
        response = StringUtils.isNotBlank((CharSequence)userId) ? new BooleanResponse(true, "Email/Phone is already registered.") : new BooleanResponse(false, "Email/Phone is not registered.");
        return response;
    }

    @Override
    public boolean shouldValidateSession() {
        return false;
    }
}

