/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.requests.processors;

import org.piangles.backbone.services.Locator;
import org.piangles.backbone.services.auth.AuthenticationResponse;
import org.piangles.backbone.services.auth.AuthenticationService;
import org.piangles.backbone.services.auth.AuthenticationType;
import org.piangles.backbone.services.auth.Credential;
import org.piangles.backbone.services.auth.FailureReason;
import org.piangles.backbone.services.session.SessionManagementService;
import org.piangles.gateway.client.ClientDetails;
import org.piangles.gateway.requests.Endpoints;
import org.piangles.gateway.requests.dto.LoginRequest;
import org.piangles.gateway.requests.dto.LoginResponse;
import org.piangles.gateway.requests.dto.Request;
import org.piangles.gateway.requests.processors.AbstractAuthenticationProcessor;

public final class LoginRequestProcessor
extends AbstractAuthenticationProcessor<LoginRequest, LoginResponse> {
    private AuthenticationService authService = Locator.getInstance().getAuthenticationService();
    private SessionManagementService sessionMgmtService = Locator.getInstance().getSessionManagementService();

    public LoginRequestProcessor() {
        super(Endpoints.Login, LoginRequest.class, LoginResponse.class);
    }

    @Override
    protected LoginResponse processRequest(ClientDetails clientDetails, Request request, LoginRequest loginRequest) throws Exception {
        LoginResponse loginResponse = null;
        if (loginRequest.getPassword() != null) {
            AuthenticationType type = AuthenticationType.valueOf((String)loginRequest.getAuthenticationType());
            AuthenticationResponse authResponse = this.authService.authenticate(type, new Credential(loginRequest.getId(), loginRequest.getPassword()));
            if (authResponse.isAuthenticated()) {
                this.process(authResponse.getUserId(), authResponse.IsValidatedByToken(), authResponse.getLastLoggedInTimestamp(), clientDetails, loginRequest.getSystemInfo());
            } else {
                loginResponse = new LoginResponse(authResponse.getNoOfAttemptsRemaining(), authResponse.getFailureReason());
            }
        } else {
            boolean isSessionValid = this.sessionMgmtService.isValid(loginRequest.getId(), loginRequest.getSessionId());
            if (isSessionValid) {
                this.sessionMgmtService.makeLastAccessedCurrent(loginRequest.getId(), loginRequest.getSessionId());
                loginResponse = new LoginResponse(false, false, loginRequest.getId(), loginRequest.getSessionId(), 900L, 0L);
            } else {
                loginResponse = new LoginResponse(0, FailureReason.InvalidSession);
            }
        }
        return loginResponse;
    }
}

