/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.client;

import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicLong;
import org.piangles.core.services.remoting.SessionDetails;
import org.piangles.gateway.ClientEndpoint;
import org.piangles.gateway.client.Location;

public final class ClientDetails {
    private InetSocketAddress remoteAddress;
    private ClientEndpoint clientEndpoint = null;
    private SessionDetails sessionDetails = null;
    private long inactivityExpiryTimeInSeconds = 0L;
    private long lastLoggedInTimestamp = 0L;
    private AtomicLong lastAccessed = null;
    private Location location = null;
    private Object applicationData;

    public ClientDetails(InetSocketAddress remoteAddress, ClientEndpoint clientEndpoint, SessionDetails sessionDetails, long inactivityExpiryTimeInSeconds, long lastLoggedInTimestamp, Location location) {
        this.remoteAddress = remoteAddress;
        this.clientEndpoint = clientEndpoint;
        this.sessionDetails = sessionDetails;
        this.inactivityExpiryTimeInSeconds = inactivityExpiryTimeInSeconds;
        this.lastLoggedInTimestamp = lastLoggedInTimestamp;
        this.lastAccessed = new AtomicLong();
        this.location = location;
    }

    public ClientEndpoint getClientEndpoint() {
        return this.clientEndpoint;
    }

    public SessionDetails getSessionDetails() {
        return this.sessionDetails;
    }

    public long getInactivityExpiryTimeInSeconds() {
        return this.inactivityExpiryTimeInSeconds;
    }

    public long getLastLoggedInTimestamp() {
        return this.lastLoggedInTimestamp;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getIPAddress() {
        return this.remoteAddress.getAddress().getHostAddress();
    }

    public String getHostName() {
        return this.remoteAddress.getHostName();
    }

    public int getPort() {
        return this.remoteAddress.getPort();
    }

    public Location getLocation() {
        return this.location;
    }

    public <T> T getApplicationData(String name) {
        return (T)this.applicationData;
    }

    public void setApplicationData(Object applicationData) {
        this.applicationData = applicationData;
    }

    public void markLastAccessed() {
        this.lastAccessed.set(System.currentTimeMillis());
    }

    public boolean hasSessionExpired() {
        return System.currentTimeMillis() - this.lastAccessed.get() >= this.inactivityExpiryTimeInSeconds * 1000L;
    }

    public String toString() {
        return "ClientDetails [remoteAddress=" + this.remoteAddress + ", sessionDetails=" + this.sessionDetails + "]";
    }
}

