/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.service.impl.jetty;

import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.piangles.core.util.Logger;
import org.piangles.gateway.GatewayConfiguration;
import org.piangles.gateway.requests.RequestProcessingManager;
import org.piangles.gateway.service.impl.jetty.ClientEndpointImpl;

@WebSocket
public final class WebSocketLifecycleEventHandler {
    private static final String IP_DELIMITER = ",";
    private static final String PORT_DELIMITER = ",";
    private static final String DEFAULT_CLIENT_PORT = "5555";
    private static final String FORWARDED_HEADER = "Forwarded";
    private static final String X_FORWARDED_FOR_HEADER = "X-Forwarded-For";
    private GatewayConfiguration gatewayConfiguration = null;
    private InetSocketAddress remoteAddr = null;
    private RequestProcessingManager rpm = null;

    public WebSocketLifecycleEventHandler(GatewayConfiguration gatewayConfiguration, Map<String, List<String>> headers) {
        this.gatewayConfiguration = gatewayConfiguration;
        this.remoteAddr = this.determineRemoteAddress(headers);
    }

    @OnWebSocketClose
    public void onClose(int statusCode, String reason) {
        this.rpm.onClose(statusCode, reason);
    }

    @OnWebSocketError
    public void onError(Throwable t) {
        this.rpm.onError(t);
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
        try {
            session.setIdleTimeout(this.gatewayConfiguration.getIdleTimeout());
            session.getPolicy().setMaxTextMessageSize(this.gatewayConfiguration.getMaxTextMessageSize());
            if (this.remoteAddr == null) {
                Logger.getInstance().warn((Object)"Remote Address was unable to be determined from Headers, using Session.");
                this.remoteAddr = session.getRemoteAddress();
            }
            this.rpm = new RequestProcessingManager(this.remoteAddr, new ClientEndpointImpl(session));
        }
        catch (Throwable t) {
            Logger.getInstance().error((Object)("Exception while creating RequestProcessingManager: " + t.getMessage()), t);
            t.printStackTrace();
            t.printStackTrace(System.out);
        }
    }

    @OnWebSocketMessage
    public void onMessage(String message) {
        this.rpm.onMessage(message);
    }

    private InetSocketAddress determineRemoteAddress(Map<String, List<String>> headers) {
        InetSocketAddress remoteAddress = null;
        try {
            remoteAddress = this.extractRemoteAddressFromXForwardedFor(headers.get(X_FORWARDED_FOR_HEADER));
            if (remoteAddress == null) {
                remoteAddress = this.extractRemoteAddressFromForwarded(headers.get(FORWARDED_HEADER));
            }
        }
        catch (Exception e) {
            Logger.getInstance().warn((Object)("Unable to determineRemoteAddress. Reason: " + e.getMessage()), (Throwable)e);
        }
        return remoteAddress;
    }

    private InetSocketAddress extractRemoteAddressFromXForwardedFor(List<String> xForwardedForHeaderValues) {
        String valueString;
        InetSocketAddress remoteAddress = null;
        if (xForwardedForHeaderValues != null && !xForwardedForHeaderValues.isEmpty() && StringUtils.isNotBlank((CharSequence)(valueString = xForwardedForHeaderValues.get(0)))) {
            if (valueString.indexOf(",") != -1) {
                valueString = valueString.substring(0, valueString.indexOf(","));
            }
            valueString = valueString.trim();
            String host = null;
            String port = null;
            if (valueString.indexOf(",") != -1) {
                host = valueString.substring(0, valueString.indexOf(","));
                port = valueString.substring(valueString.indexOf(",") + 1);
            } else {
                host = valueString;
                port = DEFAULT_CLIENT_PORT;
            }
            if (host != null) {
                remoteAddress = new InetSocketAddress(host, Integer.parseInt(port));
            }
        }
        return remoteAddress;
    }

    private InetSocketAddress extractRemoteAddressFromForwarded(List<String> forwardedHeaderValues) {
        String valueString;
        InetSocketAddress remoteAddress = null;
        if (forwardedHeaderValues == null || forwardedHeaderValues.isEmpty() || StringUtils.isNotBlank((CharSequence)(valueString = forwardedHeaderValues.get(0)))) {
            // empty if block
        }
        return remoteAddress;
    }
}

