/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.events.processors;

import org.piangles.backbone.services.Locator;
import org.piangles.backbone.services.logging.LoggingService;
import org.piangles.backbone.services.msg.Event;
import org.piangles.core.util.coding.JSON;
import org.piangles.gateway.client.ClientDetails;
import org.piangles.gateway.events.EventProcessor;

public abstract class AbstractEventProcessor<T>
implements EventProcessor {
    protected LoggingService logger = Locator.getInstance().getLoggingService();
    private String type;

    public AbstractEventProcessor(String type) {
        this.type = type;
    }

    @Override
    public final String getType() {
        return this.type;
    }

    @Override
    public final void process(ClientDetails clientDetails, Event event) {
        try {
            this.processPayload(clientDetails, this.convertPayload(event));
        }
        catch (Exception expt) {
            this.logger.info((Object)("Unable to process event : " + event), (Throwable)expt);
        }
    }

    public abstract void processPayload(ClientDetails var1, T var2) throws Exception;

    private T convertPayload(Event event) throws Exception {
        Class<?> payloadClass = Class.forName(event.getPayloadType());
        Object payload = JSON.getDecoder().decode(((String)event.getPayload()).getBytes(), payloadClass);
        return (T)payload;
    }
}

