/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.requests;

import org.piangles.backbone.services.Locator;
import org.piangles.backbone.services.logging.LoggingService;
import org.piangles.gateway.Message;
import org.piangles.gateway.MessageType;
import org.piangles.gateway.client.ClientDetails;
import org.piangles.gateway.requests.Endpoints;
import org.piangles.gateway.requests.dto.Response;

public final class ResponseSender {
    private static LoggingService logger = Locator.getInstance().getLoggingService();

    public static void sendResponse(ClientDetails clientDetails, Response response) {
        if (!Endpoints.Ping.name().equals(response.getEndpoint())) {
            if (response.isRequestSuccessful()) {
                logger.info((Object)"Request was processed successfully.");
            } else {
                logger.warn((Object)("Request could not be processed successfully because of : " + response.getErrorMessage()));
            }
        }
        try {
            clientDetails.getClientEndpoint().sendMessage(new Message(MessageType.Response, response));
            if (!Endpoints.Ping.name().equals(response.getEndpoint())) {
                logger.info((Object)"Response sent to client successfully.");
            }
        }
        catch (Exception e) {
            logger.error((Object)"Unable to send client response because of : ", (Throwable)e);
        }
    }
}

