/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.requests;

import java.util.HashMap;
import java.util.Map;
import org.piangles.core.expt.BadRequestException;
import org.piangles.core.expt.NotFoundException;
import org.piangles.core.expt.PayloadTooLargeException;
import org.piangles.core.expt.RequestedFormatNotSupportedException;
import org.piangles.core.expt.ServiceRuntimeException;
import org.piangles.core.expt.UnauthenticatedException;
import org.piangles.core.expt.UnauthorizedException;
import org.piangles.core.expt.UnsupportedMediaException;
import org.piangles.core.expt.ValidationException;
import org.piangles.core.expt.VersionMismatchException;
import org.piangles.gateway.requests.dto.StatusCode;

public final class StatusCodeMapper {
    private static StatusCodeMapper self = null;
    private Map<String, StatusCode> sreStatusCodeMap = new HashMap<String, StatusCode>();

    private StatusCodeMapper() {
        this.sreStatusCodeMap.put(BadRequestException.class.getSimpleName(), StatusCode.BadRequest);
        this.sreStatusCodeMap.put(NotFoundException.class.getSimpleName(), StatusCode.NotFound);
        this.sreStatusCodeMap.put(PayloadTooLargeException.class.getSimpleName(), StatusCode.PayloadTooLarge);
        this.sreStatusCodeMap.put(RequestedFormatNotSupportedException.class.getSimpleName(), StatusCode.RequestedFormatNotSupported);
        this.sreStatusCodeMap.put(UnauthenticatedException.class.getSimpleName(), StatusCode.Unauthenticated);
        this.sreStatusCodeMap.put(UnauthorizedException.class.getSimpleName(), StatusCode.Unauthorized);
        this.sreStatusCodeMap.put(UnsupportedMediaException.class.getSimpleName(), StatusCode.UnsupportedMedia);
        this.sreStatusCodeMap.put(ValidationException.class.getSimpleName(), StatusCode.ValidationFailure);
        this.sreStatusCodeMap.put(VersionMismatchException.class.getSimpleName(), StatusCode.VersionMismatch);
    }

    public static synchronized StatusCodeMapper getInstance() {
        if (self == null) {
            self = new StatusCodeMapper();
        }
        return self;
    }

    public StatusCode getStatusCode(ServiceRuntimeException sre) {
        return this.sreStatusCodeMap.get(sre.getClass().getSimpleName());
    }
}

