/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.requests.processors;

import org.piangles.backbone.services.Locator;
import org.piangles.backbone.services.auth.FailureReason;
import org.piangles.backbone.services.profile.BasicUserProfile;
import org.piangles.backbone.services.profile.UserProfileService;
import org.piangles.backbone.services.session.SessionDetails;
import org.piangles.backbone.services.session.SessionManagementException;
import org.piangles.backbone.services.session.SessionManagementService;
import org.piangles.gateway.CommunicationPattern;
import org.piangles.gateway.client.ClientDetails;
import org.piangles.gateway.requests.dao.UserDeviceInfo;
import org.piangles.gateway.requests.dto.LoginResponse;
import org.piangles.gateway.requests.dto.SystemInfo;
import org.piangles.gateway.requests.processors.AbstractRequestProcessor;

public abstract class AbstractAuthenticationProcessor<EndpointReq, EndpointResp>
extends AbstractRequestProcessor<EndpointReq, EndpointResp> {
    private static final String MAX_ACTIVE_SESSION_MESAGE_1 = "already has an active session";
    private static final String MAX_ACTIVE_SESSION_MESAGE_2 = "has reached maximum active sessions";
    private SessionManagementService sessionMgmtService = Locator.getInstance().getSessionManagementService();
    private UserProfileService profileService = Locator.getInstance().getUserProfileService();

    public AbstractAuthenticationProcessor(Enum<?> endpoint, Class<EndpointReq> requestClass, Class<EndpointResp> responseClass) {
        super(endpoint, CommunicationPattern.RequestResponse, requestClass, responseClass);
    }

    public LoginResponse processGuestLogin(String userId, ClientDetails clientDetails, SystemInfo systemInfo) throws Exception {
        return this.processRegularLogin(userId, false, true, System.currentTimeMillis(), clientDetails, systemInfo);
    }

    public LoginResponse processRegularLogin(String userId, boolean validatedByToken, boolean loggedInAsGuest, long lastLoggedInTimestamp, ClientDetails clientDetails, SystemInfo systemInfo) throws Exception {
        LoginResponse loginResponse = null;
        UserDeviceInfo userDeviceInfo = new UserDeviceInfo(userId, clientDetails.getHostName(), clientDetails.getIPAddress(), systemInfo);
        this.getGatewayDAO().insertUserDeviceInfo(userDeviceInfo);
        SessionDetails sessionDetails = null;
        try {
            sessionDetails = this.sessionMgmtService.register(userId);
            this.setSessionForCurrentThread(sessionDetails);
            BasicUserProfile userProfile = this.profileService.getProfile(userId);
            loginResponse = new LoginResponse(userProfile.isMFAEnabled(), validatedByToken, loggedInAsGuest, userId, sessionDetails.getSessionId(), sessionDetails.getInactivityExpiryTimeInSeconds(), lastLoggedInTimestamp);
        }
        catch (SessionManagementException e) {
            String message = e.getMessage();
            if (message.contains(MAX_ACTIVE_SESSION_MESAGE_1) || message.contains(MAX_ACTIVE_SESSION_MESAGE_2)) {
                loginResponse = new LoginResponse(0, FailureReason.MaximumSessionCountReached);
            }
            throw e;
        }
        return loginResponse;
    }

    @Override
    public final boolean shouldValidateSession() {
        return false;
    }
}

