/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.requests.processors;

import org.piangles.backbone.services.Locator;
import org.piangles.backbone.services.profile.BasicUserProfile;
import org.piangles.backbone.services.profile.UserProfileService;
import org.piangles.core.expt.UnsupportedMediaException;
import org.piangles.gateway.client.ClientDetails;
import org.piangles.gateway.requests.Endpoints;
import org.piangles.gateway.requests.RequestRouter;
import org.piangles.gateway.requests.dto.Request;
import org.piangles.gateway.requests.dto.SimpleResponse;
import org.piangles.gateway.requests.processors.AbstractRequestProcessor;

public class SendMFATokenRequestProcessor
extends AbstractRequestProcessor<BasicUserProfile, SimpleResponse> {
    private UserProfileService profileService = Locator.getInstance().getUserProfileService();

    public SendMFATokenRequestProcessor() {
        super(Endpoints.SendMFAToken, BasicUserProfile.class, SimpleResponse.class);
    }

    @Override
    protected SimpleResponse processRequest(ClientDetails clientDetails, Request request, BasicUserProfile upRequest) throws Exception {
        SimpleResponse simpleResponse = null;
        if (RequestRouter.getInstance().getMFAManager() == null) {
            throw new UnsupportedMediaException("Multi-Factor Authentication has not been setup.");
        }
        RequestRouter.getInstance().getMFAManager().sendMFAToken(clientDetails);
        simpleResponse = new SimpleResponse("Please check your registered device for the token.");
        return simpleResponse;
    }
}

