/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.requests;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.piangles.backbone.services.Locator;
import org.piangles.backbone.services.logging.LoggingService;
import org.piangles.core.util.validate.ValidationManager;
import org.piangles.core.util.validate.Validator;
import org.piangles.gateway.requests.Communicator;
import org.piangles.gateway.requests.Endpoints;
import org.piangles.gateway.requests.MFAManager;
import org.piangles.gateway.requests.RequestProcessor;
import org.piangles.gateway.requests.dao.GatewayDAO;
import org.piangles.gateway.requests.dao.GatewayDAOImpl;
import org.piangles.gateway.requests.hooks.MidAuthenticationHook;
import org.piangles.gateway.requests.hooks.PostAuthenticationHook;
import org.piangles.gateway.requests.hooks.PostRequestProcessingHook;
import org.piangles.gateway.requests.processors.AutoSuggestRequestProcessor;
import org.piangles.gateway.requests.processors.ChangePasswordRequestProcessor;
import org.piangles.gateway.requests.processors.CreateUserProfileRequestProcessor;
import org.piangles.gateway.requests.processors.EndpointMetadataRequestProcessor;
import org.piangles.gateway.requests.processors.GeneratePasswordResetTokenRequestProcessor;
import org.piangles.gateway.requests.processors.GetConfigRequestProcessor;
import org.piangles.gateway.requests.processors.GetUserPreferencesRequestProcessor;
import org.piangles.gateway.requests.processors.GetUserProfileRequestProcessor;
import org.piangles.gateway.requests.processors.KeepSessionAliveRequestProcessor;
import org.piangles.gateway.requests.processors.ListEndpointsRequestProcessor;
import org.piangles.gateway.requests.processors.LoginRequestProcessor;
import org.piangles.gateway.requests.processors.LogoutRequestProcessor;
import org.piangles.gateway.requests.processors.MFASetupRequestProcessor;
import org.piangles.gateway.requests.processors.SendMFATokenRequestProcessor;
import org.piangles.gateway.requests.processors.SignUpRequestProcessor;
import org.piangles.gateway.requests.processors.SubscriptionRequestProcessor;
import org.piangles.gateway.requests.processors.UpdateUserPreferencesRequestProcessor;
import org.piangles.gateway.requests.processors.UpdateUserProfileRequestProcessor;
import org.piangles.gateway.requests.processors.UserProfileExistsRequestProcessor;
import org.piangles.gateway.requests.processors.ValidateMFATokenRequestProcessor;
import org.piangles.gateway.requests.validators.ChangePasswordRequestValidator;
import org.piangles.gateway.requests.validators.GenericContactRequestValidator;
import org.piangles.gateway.requests.validators.LoginRequestValidator;
import org.piangles.gateway.requests.validators.SignUpRequestValidator;
import org.piangles.gateway.requests.validators.SubscriptionRequestValidator;

public class RequestRouter {
    private static RequestRouter self = null;
    private LoggingService logger = Locator.getInstance().getLoggingService();
    private GatewayDAO gatewayDAO = null;
    private Map<String, Enum<?>> preAuthenticationEndpoints = null;
    private Map<String, Enum<?>> authenticationEndpoints = null;
    private Map<String, Enum<?>> midAuthenticationEndpoints = null;
    private Map<String, RequestProcessor> endpointRequestProcessorMap;
    private PostRequestProcessingHook postRequestProcessingHook = null;
    private MidAuthenticationHook midAuthenticationHook = null;
    private PostAuthenticationHook postAuthenticationHook = null;
    private Communicator communicator = null;
    private MFAManager mfaManager = null;

    private RequestRouter() {
        try {
            this.gatewayDAO = new GatewayDAOImpl();
        }
        catch (Exception e) {
            String message = "Unable to create RequestRouter becaue of DAO Failure. Reason: " + e.getMessage();
            this.logger.fatal((Object)message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
        this.preAuthenticationEndpoints = new HashMap();
        this.authenticationEndpoints = new HashMap();
        this.midAuthenticationEndpoints = new HashMap();
        this.endpointRequestProcessorMap = new HashMap<String, RequestProcessor>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RequestRouter getInstance() {
        if (self != null) return self;
        Class<RequestRouter> clazz = RequestRouter.class;
        synchronized (RequestRouter.class) {
            if (self != null) return self;
            self = new RequestRouter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return self;
        }
    }

    public GatewayDAO getGatewayDAO() {
        return this.gatewayDAO;
    }

    public void registerDefaultPreAuthenticationEndpoints() {
        this.registerPreAuthenticationEndpoint(Endpoints.ListEndpoints.name(), Endpoints.ListEndpoints);
        this.registerPreAuthenticationEndpoint(Endpoints.EndpointMetadata.name(), Endpoints.EndpointMetadata);
        this.registerPreAuthenticationEndpoint(Endpoints.UserProfileExists.name(), Endpoints.UserProfileExists);
        this.registerPreAuthenticationEndpoint(Endpoints.SignUp.name(), Endpoints.SignUp);
        this.registerPreAuthenticationEndpoint(Endpoints.Login.name(), Endpoints.Login);
        this.registerPreAuthenticationEndpoint(Endpoints.GeneratePasswordResetToken.name(), Endpoints.GeneratePasswordResetToken);
    }

    public void registerDefaultAuthenticationEndpoints() {
        this.registerAuthenticationEndpoint(Endpoints.SignUp.name(), Endpoints.SignUp);
        this.registerAuthenticationEndpoint(Endpoints.Login.name(), Endpoints.Login);
    }

    public void registerDefaultMidAuthenticationEndpoints() {
        this.registerMidAuthenticationEndpoint(Endpoints.ChangePassword.name(), Endpoints.ChangePassword);
        this.registerMidAuthenticationEndpoint(Endpoints.ValidateMFAToken.name(), Endpoints.ValidateMFAToken);
        this.registerMidAuthenticationEndpoint(Endpoints.SendMFAToken.name(), Endpoints.SendMFAToken);
        this.registerMidAuthenticationEndpoint(Endpoints.Ping.name(), Endpoints.Ping);
    }

    public void registerDefaultRequestProcessors() {
        this.registerRequestProcessor(this.createRequestProcessor(ListEndpointsRequestProcessor.class));
        this.registerRequestProcessor(this.createRequestProcessor(EndpointMetadataRequestProcessor.class));
        this.registerRequestProcessor(this.createRequestProcessor(UserProfileExistsRequestProcessor.class));
        this.registerRequestProcessor(this.createRequestProcessor(SignUpRequestProcessor.class));
        this.registerRequestProcessor(this.createRequestProcessor(LoginRequestProcessor.class));
        this.registerRequestProcessor(this.createRequestProcessor(GeneratePasswordResetTokenRequestProcessor.class));
        this.registerRequestProcessor(this.createRequestProcessor(MFASetupRequestProcessor.class));
        this.registerRequestProcessor(this.createRequestProcessor(SendMFATokenRequestProcessor.class));
        this.registerRequestProcessor(this.createRequestProcessor(ValidateMFATokenRequestProcessor.class));
        this.registerRequestProcessor(this.createRequestProcessor(ChangePasswordRequestProcessor.class));
        this.registerRequestProcessor(this.createRequestProcessor(LogoutRequestProcessor.class));
        this.registerRequestProcessor(this.createRequestProcessor(KeepSessionAliveRequestProcessor.class));
        this.registerRequestProcessor(this.createRequestProcessor(CreateUserProfileRequestProcessor.class));
        this.registerRequestProcessor(this.createRequestProcessor(UpdateUserProfileRequestProcessor.class));
        this.registerRequestProcessor(this.createRequestProcessor(GetUserProfileRequestProcessor.class));
        this.registerRequestProcessor(this.createRequestProcessor(GetConfigRequestProcessor.class));
        this.registerRequestProcessor(this.createRequestProcessor(GetUserPreferencesRequestProcessor.class));
        this.registerRequestProcessor(this.createRequestProcessor(UpdateUserPreferencesRequestProcessor.class));
        this.registerRequestProcessor(this.createRequestProcessor(SubscriptionRequestProcessor.class));
        this.registerRequestProcessor(this.createRequestProcessor(AutoSuggestRequestProcessor.class));
    }

    public void registerDefaultRequestValidators() {
        this.registerRequestValidator(new GenericContactRequestValidator(Endpoints.UserProfileExists));
        this.registerRequestValidator(new SignUpRequestValidator());
        this.registerRequestValidator(new LoginRequestValidator());
        this.registerRequestValidator(new ChangePasswordRequestValidator());
        this.registerRequestValidator(new SubscriptionRequestValidator());
    }

    public void registerPreAuthenticationEndpoint(String endpointName, Enum<?> endpoint) {
        this.preAuthenticationEndpoints.put(endpointName, endpoint);
    }

    public void registerAuthenticationEndpoint(String endpointName, Enum<?> endpoint) {
        this.authenticationEndpoints.put(endpointName, endpoint);
    }

    public void registerMidAuthenticationEndpoint(String endpointName, Enum<?> endpoint) {
        this.midAuthenticationEndpoints.put(endpointName, endpoint);
    }

    public void registerRequestProcessor(RequestProcessor rp) {
        if (rp != null) {
            rp.setGatewayDAO(this.gatewayDAO);
            String registringOrOverriding = null;
            RequestProcessor existingRP = this.endpointRequestProcessorMap.get(rp.getEndpoint().name());
            if (existingRP != null) {
                this.logger.warn((Object)("Request Router already has a registered endpoint : " + rp.getEndpoint() + " : " + existingRP.getClass().getCanonicalName()));
                registringOrOverriding = "Overriding";
            } else {
                registringOrOverriding = "Registering";
            }
            this.logger.info((Object)(registringOrOverriding + " " + rp.getEndpoint() + " with : " + rp.getClass().getCanonicalName()));
            this.endpointRequestProcessorMap.put(rp.getEndpoint().name(), rp);
        } else {
            this.logger.error((Object)"registerRequestProcessor: RequestProcessor is null.");
        }
    }

    public void registerRequestValidator(Validator validator) {
        String registringOrOverriding = null;
        String endpoint = validator.getName();
        Validator existingValidator = ValidationManager.getInstance().getValidator(endpoint);
        if (existingValidator != null) {
            this.logger.warn((Object)("Validator already exists for : " + endpoint + " : " + existingValidator.getClass().getCanonicalName()));
            registringOrOverriding = "Overriding";
        } else {
            registringOrOverriding = "Registering";
        }
        this.logger.info((Object)(registringOrOverriding + " " + endpoint + " Validator with : " + validator.getClass().getCanonicalName()));
        ValidationManager.getInstance().addValidator(validator);
    }

    public void registerPostRequestProcessingHook(PostRequestProcessingHook postRequestProcessingHook) {
        this.postRequestProcessingHook = postRequestProcessingHook;
    }

    public void registerMidAuthenticationHook(MidAuthenticationHook midAuthenticationHook) {
        this.midAuthenticationHook = midAuthenticationHook;
    }

    public void registerPostAuthenticationHook(PostAuthenticationHook postAuthenticationHook) {
        this.postAuthenticationHook = postAuthenticationHook;
    }

    public void registerCommunicator(Communicator communicator) {
        this.communicator = communicator;
    }

    public void registerMFAManager(MFAManager mfaManager) {
        this.mfaManager = mfaManager;
    }

    public boolean isPreAuthenticationEndpoint(String endpoint) {
        return this.preAuthenticationEndpoints.containsKey(endpoint);
    }

    public boolean isAuthenticationEndpoint(String endpoint) {
        return this.authenticationEndpoints.containsKey(endpoint);
    }

    public boolean isMidAuthenticationEndpoint(String endpoint) {
        return this.midAuthenticationEndpoints.containsKey(endpoint);
    }

    public Set<String> getRegisteredEndpoints() {
        return this.endpointRequestProcessorMap.keySet();
    }

    public RequestProcessor getRequestProcessor(String endpoint) {
        return this.endpointRequestProcessorMap.get(endpoint);
    }

    public PostRequestProcessingHook getPostRequestProcessingHook() {
        return this.postRequestProcessingHook;
    }

    public MidAuthenticationHook getMidAuthenticationHook() {
        return this.midAuthenticationHook;
    }

    public PostAuthenticationHook getPostAuthenticationHook() {
        return this.postAuthenticationHook;
    }

    public Communicator getCommunicator() {
        return this.communicator;
    }

    public MFAManager getMFAManager() {
        return this.mfaManager;
    }

    public void clearRequestProcessors() {
        this.endpointRequestProcessorMap.clear();
    }

    public void clearRequestValidators() {
        ValidationManager.getInstance().clear();
    }

    private RequestProcessor createRequestProcessor(Class<?> rpClass) {
        RequestProcessor rp = null;
        try {
            rp = (RequestProcessor)rpClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            this.logger.warn((Object)("Unable to create " + rpClass.getCanonicalName() + " because of : " + e.getMessage()));
        }
        return rp;
    }
}

