/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.requests.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.UUID;

public final class Request {
    @JsonProperty(required=true)
    private long issuedTime = System.currentTimeMillis();
    @JsonIgnore
    private long receiptTime;
    @JsonIgnore
    private long transitTime;
    @JsonProperty(required=true)
    private UUID traceId = UUID.randomUUID();
    @JsonProperty(required=true)
    private String sessionId = null;
    @JsonProperty(required=true)
    private String endpoint = null;
    @JsonProperty(required=true)
    private String endpointRequest = null;

    public Request(String sessionId, String endpoint, String endpointRequest) {
        this.sessionId = sessionId;
        this.endpoint = endpoint;
        this.endpointRequest = endpointRequest;
    }

    public long getIssuedTime() {
        return this.issuedTime;
    }

    public long getReceiptTime() {
        return this.receiptTime;
    }

    public void markTransitTime() {
        this.receiptTime = System.currentTimeMillis();
        this.transitTime = this.receiptTime - this.issuedTime;
    }

    public long getTransitTime() {
        return this.transitTime;
    }

    public UUID getTraceId() {
        return this.traceId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getEndpointRequest() {
        return this.endpointRequest;
    }

    public String toString() {
        return "Request [issuedTime=" + this.issuedTime + ", traceId=" + this.traceId + ", sessionId=" + this.sessionId + ", endpoint=" + this.endpoint + "]";
    }
}

