/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.requests.processors;

import org.piangles.backbone.services.Locator;
import org.piangles.backbone.services.logging.LoggingService;
import org.piangles.backbone.services.session.SessionDetails;
import org.piangles.core.expt.BadRequestException;
import org.piangles.core.util.coding.JSON;
import org.piangles.core.util.validate.ValidationManager;
import org.piangles.core.util.validate.Validator;
import org.piangles.gateway.CommunicationPattern;
import org.piangles.gateway.client.ClientDetails;
import org.piangles.gateway.events.EventProcessingManager;
import org.piangles.gateway.requests.RequestProcessingThread;
import org.piangles.gateway.requests.RequestProcessor;
import org.piangles.gateway.requests.RequestRouter;
import org.piangles.gateway.requests.dao.GatewayDAO;
import org.piangles.gateway.requests.dao.RequestResponseDetails;
import org.piangles.gateway.requests.dto.EmptyRequest;
import org.piangles.gateway.requests.dto.Request;
import org.piangles.gateway.requests.dto.Response;
import org.piangles.gateway.requests.dto.StatusCode;
import org.piangles.gateway.requests.validators.DefaultGatewayRequestValidator;

public abstract class AbstractRequestProcessor<EndpointReq, EndpointResp>
implements RequestProcessor {
    private LoggingService logger = Locator.getInstance().getLoggingService();
    private Enum<?> endpoint;
    private CommunicationPattern communicationPattern;
    private Class<EndpointReq> endpointRequestClass = null;
    private Class<EndpointResp> endpointResponseClass = null;
    private GatewayDAO gatewayDAO = null;
    private DefaultGatewayRequestValidator<EndpointReq> gatewayRequestValidator = null;

    public AbstractRequestProcessor(Enum<?> endpoint, Class<EndpointReq> requestClass, Class<EndpointResp> responseClass) {
        this(endpoint, CommunicationPattern.RequestAsynchronousResponse, requestClass, responseClass);
    }

    public AbstractRequestProcessor(Enum<?> endpoint, CommunicationPattern communicationPattern, Class<EndpointReq> endpointRequestClass, Class<EndpointResp> endpointResponseClass) {
        this.endpoint = endpoint;
        this.communicationPattern = communicationPattern;
        this.endpointRequestClass = endpointRequestClass;
        this.endpointResponseClass = endpointResponseClass;
        this.gatewayRequestValidator = new DefaultGatewayRequestValidator<EndpointReq>(endpointRequestClass);
    }

    @Override
    public final Response processRequest(ClientDetails clientDetails, Request request) throws Exception {
        Response response = null;
        Object epRequest = null;
        if (!EmptyRequest.class.equals(this.endpointRequestClass) && request.getEndpointRequest() != null) {
            try {
                epRequest = JSON.getDecoder().decode(request.getEndpointRequest().getBytes(), this.endpointRequestClass);
            }
            catch (Exception e) {
                String message = "EndpointRequest for: " + request.getEndpoint() + " could not be decoded.";
                this.logger.error((Object)(message + " Reason: " + e.getMessage()), (Throwable)e);
                throw new BadRequestException(message);
            }
        }
        this.gatewayRequestValidator.validate(clientDetails, request, epRequest);
        Validator validator = ValidationManager.getInstance().getValidator(request.getEndpoint());
        if (validator != null) {
            validator.validate(new Object[]{clientDetails, request, epRequest});
        }
        EndpointResp epResponse = this.processRequest(clientDetails, request, epRequest);
        String epResponseAsStr = new String(JSON.getEncoder().encode(epResponse));
        response = new Response(request.getTraceId(), request.getEndpoint(), request.getReceiptTime(), request.getTransitTime(), StatusCode.Success, epResponseAsStr);
        if (RequestRouter.getInstance().getPostRequestProcessingHook() != null) {
            try {
                RequestResponseDetails reqRespDetails = new RequestResponseDetails(clientDetails, request, response);
                RequestRouter.getInstance().getPostRequestProcessingHook().process(clientDetails, reqRespDetails, epRequest, epResponse);
            }
            catch (Throwable e) {
                this.logger.warn((Object)("IGNORING: Exception while PostRequestProcessingHook. Reason: " + e.getMessage()), e);
            }
        }
        return response;
    }

    @Override
    public final Enum<?> getEndpoint() {
        return this.endpoint;
    }

    @Override
    public final Class<?> getEndpointRequestClass() {
        return this.endpointRequestClass;
    }

    @Override
    public final Class<?> getEndpointResponseClass() {
        return this.endpointResponseClass;
    }

    @Override
    public final CommunicationPattern getCommunicationPattern() {
        return this.communicationPattern;
    }

    @Override
    public boolean shouldValidateSession() {
        return true;
    }

    @Override
    public final void setGatewayDAO(GatewayDAO gatewayDAO) {
        this.gatewayDAO = gatewayDAO;
    }

    protected final GatewayDAO getGatewayDAO() {
        return this.gatewayDAO;
    }

    protected final EventProcessingManager getEventProcessingManager() {
        EventProcessingManager npm = null;
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof RequestProcessingThread) {
            npm = ((RequestProcessingThread)((Object)currentThread)).getMessageProcessingManager();
        }
        return npm;
    }

    protected final void setSessionForCurrentThread(SessionDetails svcSessionDetails) {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof RequestProcessingThread) {
            org.piangles.core.services.remoting.SessionDetails gatewaySessionDetails = null;
            gatewaySessionDetails = new org.piangles.core.services.remoting.SessionDetails(svcSessionDetails.getUserId(), svcSessionDetails.getSessionId());
            ((RequestProcessingThread)((Object)currentThread)).setSessionDetails(gatewaySessionDetails);
        }
    }

    protected abstract EndpointResp processRequest(ClientDetails var1, Request var2, EndpointReq var3) throws Exception;
}

