/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.requests.processors;

import org.piangles.backbone.services.Locator;
import org.piangles.backbone.services.auth.AuthenticationResponse;
import org.piangles.backbone.services.auth.AuthenticationService;
import org.piangles.core.expt.NotFoundException;
import org.piangles.core.expt.ServiceRuntimeException;
import org.piangles.core.expt.ValidationException;
import org.piangles.gateway.CommunicationPattern;
import org.piangles.gateway.client.ClientDetails;
import org.piangles.gateway.requests.Endpoints;
import org.piangles.gateway.requests.RequestRouter;
import org.piangles.gateway.requests.dto.ChangePasswordRequest;
import org.piangles.gateway.requests.dto.Request;
import org.piangles.gateway.requests.dto.SimpleResponse;
import org.piangles.gateway.requests.processors.AbstractRequestProcessor;

public class ChangePasswordRequestProcessor
extends AbstractRequestProcessor<ChangePasswordRequest, SimpleResponse> {
    private AuthenticationService authService = Locator.getInstance().getAuthenticationService();

    public ChangePasswordRequestProcessor() {
        super(Endpoints.ChangePassword, CommunicationPattern.RequestResponse, ChangePasswordRequest.class, SimpleResponse.class);
    }

    @Override
    protected SimpleResponse processRequest(ClientDetails clientDetails, Request request, ChangePasswordRequest chgPassRequest) throws Exception {
        SimpleResponse simpleResponse = null;
        AuthenticationResponse authResponse = this.authService.changePassword(clientDetails.getSessionDetails().getUserId(), chgPassRequest.getOldPassword(), chgPassRequest.getNewPassword());
        if (RequestRouter.getInstance().getCommunicator() != null) {
            RequestRouter.getInstance().getCommunicator().sendPasswordChangeAttemptCommunication(clientDetails, authResponse);
        }
        if (!authResponse.isRequestSuccessful()) {
            StringBuffer sb = new StringBuffer();
            authResponse.getFailureMessages().stream().map(msg -> sb.append((String)msg).append("\n"));
            switch (authResponse.getFailureReason()) {
                case AccountDoesNotExist: {
                    throw new NotFoundException(sb.toString());
                }
                case PasswordDoesNotMeetStrength: {
                    throw new ValidationException(sb.toString());
                }
            }
            throw new ServiceRuntimeException("Unhandled FailureReason : " + authResponse.getFailureReason() + "\n" + sb.toString());
        }
        simpleResponse = new SimpleResponse("Password changed successfully.");
        return simpleResponse;
    }
}

