/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.requests.processors;

import org.piangles.backbone.services.Locator;
import org.piangles.backbone.services.auth.AuthenticationResponse;
import org.piangles.backbone.services.auth.AuthenticationService;
import org.piangles.backbone.services.auth.AuthenticationType;
import org.piangles.backbone.services.auth.Credential;
import org.piangles.backbone.services.auth.FailureReason;
import org.piangles.backbone.services.profile.BasicUserProfile;
import org.piangles.backbone.services.profile.UserProfileService;
import org.piangles.backbone.services.session.SessionDetails;
import org.piangles.backbone.services.session.SessionManagementService;
import org.piangles.gateway.client.ClientDetails;
import org.piangles.gateway.requests.Endpoints;
import org.piangles.gateway.requests.dto.LoginRequest;
import org.piangles.gateway.requests.dto.LoginResponse;
import org.piangles.gateway.requests.dto.Request;
import org.piangles.gateway.requests.processors.AbstractAuthenticationProcessor;

public final class LoginRequestProcessor
extends AbstractAuthenticationProcessor<LoginRequest, LoginResponse> {
    private AuthenticationService authService = Locator.getInstance().getAuthenticationService();
    private SessionManagementService sessionMgmtService = Locator.getInstance().getSessionManagementService();
    private UserProfileService profileService = Locator.getInstance().getUserProfileService();

    public LoginRequestProcessor() {
        super(Endpoints.Login, LoginRequest.class, LoginResponse.class);
    }

    @Override
    protected LoginResponse processRequest(ClientDetails clientDetails, Request request, LoginRequest loginRequest) throws Exception {
        LoginResponse loginResponse = null;
        if (loginRequest.getPassword() != null) {
            AuthenticationType type = AuthenticationType.valueOf((String)loginRequest.getAuthenticationType());
            AuthenticationResponse authResponse = this.authService.authenticate(type, new Credential(loginRequest.getId(), loginRequest.getPassword()));
            loginResponse = authResponse.isAuthenticated() ? this.processRegularLogin(authResponse.getUserId(), authResponse.IsValidatedByToken(), false, authResponse.getLastLoggedInTimestamp(), clientDetails, loginRequest.getSystemInfo()) : new LoginResponse(authResponse.getNoOfAttemptsRemaining(), authResponse.getFailureReason());
        } else {
            boolean isSessionValid = this.sessionMgmtService.isValid(loginRequest.getId(), loginRequest.getSessionId());
            if (isSessionValid) {
                this.sessionMgmtService.makeLastAccessedCurrent(loginRequest.getId(), loginRequest.getSessionId());
                SessionDetails sessionDetails = this.sessionMgmtService.getSessionDetails(loginRequest.getId(), loginRequest.getSessionId());
                this.setSessionForCurrentThread(sessionDetails);
                BasicUserProfile userProfile = this.profileService.getProfile(loginRequest.getId());
                boolean mfaEnabled = userProfile.isMFAEnabled();
                boolean authenticatedByMultiFactor = sessionDetails.isAuthenticatedByMultiFactor();
                boolean authEntryExists = this.authService.doesAuthenticationEntryExist(loginRequest.getId());
                boolean loggedInAsGuest = !authEntryExists;
                loginResponse = new LoginResponse(mfaEnabled, false, true, authenticatedByMultiFactor, loggedInAsGuest, loginRequest.getId(), loginRequest.getSessionId(), userProfile.getPhoneNo(), sessionDetails.getInactivityExpiryTimeInSeconds(), 0L);
            } else {
                loginResponse = new LoginResponse(0, FailureReason.InvalidSession);
            }
        }
        return loginResponse;
    }
}

