/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.requests.processors;

import org.piangles.backbone.services.Locator;
import org.piangles.backbone.services.profile.BasicUserProfile;
import org.piangles.backbone.services.profile.UserProfileService;
import org.piangles.backbone.services.session.SessionManagementService;
import org.piangles.core.expt.UnsupportedMediaException;
import org.piangles.gateway.client.ClientDetails;
import org.piangles.gateway.requests.Endpoints;
import org.piangles.gateway.requests.RequestRouter;
import org.piangles.gateway.requests.dto.BooleanResponse;
import org.piangles.gateway.requests.dto.MFASetupRequest;
import org.piangles.gateway.requests.dto.Request;
import org.piangles.gateway.requests.processors.AbstractRequestProcessor;

public class MFASetupRequestProcessor
extends AbstractRequestProcessor<MFASetupRequest, BooleanResponse> {
    private SessionManagementService sessionMgmtService = Locator.getInstance().getSessionManagementService();
    private UserProfileService profileService = Locator.getInstance().getUserProfileService();

    public MFASetupRequestProcessor() {
        super(Endpoints.MFASetup, MFASetupRequest.class, BooleanResponse.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected BooleanResponse processRequest(ClientDetails clientDetails, Request request, MFASetupRequest mfaSetupRequest) throws Exception {
        BooleanResponse booleanResponse = null;
        BasicUserProfile userProfile = this.profileService.getProfile(clientDetails.getSessionDetails().getUserId());
        if (mfaSetupRequest.isEnabled()) {
            if (RequestRouter.getInstance().getMFAManager() == null) throw new UnsupportedMediaException("Multi-Factor Authentication has not been setup.");
            boolean validation = RequestRouter.getInstance().getMFAManager().validateMFAToken(clientDetails, mfaSetupRequest.getToken());
            userProfile = new BasicUserProfile(userProfile.getUserId(), userProfile.getFirstName(), userProfile.getLastName(), userProfile.getEMailId(), userProfile.isEmailIdVerified(), userProfile.getPhoneNo(), validation, validation);
            if (validation) {
                this.sessionMgmtService.markAuthenticatedByMFA(clientDetails.getSessionDetails().getUserId(), clientDetails.getSessionDetails().getSessionId());
            }
            booleanResponse = new BooleanResponse(validation, validation ? "MFA Enabled" : "Invalid MFA Token");
        } else {
            if (RequestRouter.getInstance().getMFAManager() == null) throw new UnsupportedMediaException("Multi-Factor Authentication has not been setup.");
            boolean validation = RequestRouter.getInstance().getMFAManager().validateMFAToken(clientDetails, mfaSetupRequest.getToken());
            if (validation) {
                userProfile = new BasicUserProfile(userProfile.getUserId(), userProfile.getFirstName(), userProfile.getLastName(), userProfile.getEMailId(), userProfile.isEmailIdVerified(), userProfile.getPhoneNo(), false, false);
                booleanResponse = new BooleanResponse(true, "MFA Disabled");
            } else {
                booleanResponse = new BooleanResponse(false, "Invalid MFA Token");
            }
        }
        if (!booleanResponse.isCriteriaSatisfied()) return booleanResponse;
        this.profileService.updateProfile(clientDetails.getSessionDetails().getUserId(), userProfile);
        if (RequestRouter.getInstance().getCommunicator() == null) return booleanResponse;
        RequestRouter.getInstance().getCommunicator().sendMFASetupCommunication(clientDetails, userProfile);
        return booleanResponse;
    }
}

