/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.events;

import java.util.HashMap;
import java.util.Map;
import org.piangles.backbone.services.Locator;
import org.piangles.backbone.services.logging.LoggingService;
import org.piangles.backbone.services.msg.Control;
import org.piangles.backbone.services.msg.Event;
import org.piangles.core.util.coding.JSON;
import org.piangles.gateway.events.EventProcessor;
import org.piangles.gateway.events.processors.PassThruApplicationEventsProcessor;
import org.piangles.gateway.events.processors.PassThruControlEventProcessor;

public class EventRouter {
    private static final String EVENT_TYPE_CONTROL = "Control";
    private LoggingService logger = Locator.getInstance().getLoggingService();
    private static EventRouter self = null;
    private boolean automaticPassThru = false;
    private EventProcessor passThruControlProcessor = null;
    private EventProcessor passThruNotificationProcessor = null;
    private Map<String, EventProcessor> eventProcessorMap = new HashMap<String, EventProcessor>();

    private EventRouter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EventRouter getInstance() {
        if (self != null) return self;
        Class<EventRouter> clazz = EventRouter.class;
        synchronized (EventRouter.class) {
            if (self != null) return self;
            self = new EventRouter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return self;
        }
    }

    public EventProcessor getProcessor(Event event) throws Exception {
        String processorId = null;
        if (EVENT_TYPE_CONTROL.equals(event.getEventType())) {
            Control controlDetails = (Control)JSON.getDecoder().decode(((String)event.getPayload()).getBytes(), Control.class);
            processorId = this.createControlEventProcessorId(controlDetails.getType());
        } else {
            processorId = event.getPayloadType();
        }
        EventProcessor ep = this.eventProcessorMap.get(processorId);
        if (ep == null && this.automaticPassThru) {
            ep = EVENT_TYPE_CONTROL.equals(event.getEventType()) ? this.passThruControlProcessor : this.passThruNotificationProcessor;
        } else {
            this.logger.error((Object)("Unable to find EventProcessor for:" + processorId));
        }
        return ep;
    }

    public void registerControlProcessor(String contolPayloadType, EventProcessor eventProcessor) {
        this.register(this.createControlEventProcessorId(contolPayloadType), eventProcessor);
    }

    public void registerNotificationProcessor(EventProcessor eventProcessor) {
        this.register(eventProcessor.getType(), eventProcessor);
    }

    public void registerPassThruProcessor(String eventType, String payloadType) {
        String processorId = null;
        EventProcessor ep = null;
        if (EVENT_TYPE_CONTROL.equals(eventType)) {
            ep = new PassThruControlEventProcessor();
            processorId = this.createControlEventProcessorId(payloadType);
        } else {
            processorId = payloadType;
            ep = new PassThruApplicationEventsProcessor(payloadType);
        }
        this.register(processorId, ep);
    }

    private void register(String processorId, EventProcessor eventProcessor) {
        if (this.eventProcessorMap.containsKey(processorId)) {
            throw new RuntimeException("Event Router already has a registered endpoint : " + eventProcessor.getType());
        }
        this.logger.info((Object)("Registering EventProcessor for Id:" + processorId));
        this.eventProcessorMap.put(processorId, eventProcessor);
    }

    public void enableAutomaticPassThru() {
        this.automaticPassThru = true;
        this.passThruControlProcessor = new PassThruControlEventProcessor();
        this.passThruNotificationProcessor = new PassThruApplicationEventsProcessor("AutoPassThru");
    }

    public boolean isAutomaticPassThru() {
        if (this.automaticPassThru) {
            this.logger.info((Object)"AutomaticPassThru is Enabled:  PassThruEventProcessor will be used when event processor is not found.");
        } else {
            this.logger.info((Object)"AutomaticPassThru is Disabled. Error will be thrown, when event processor is not found.");
        }
        return this.automaticPassThru;
    }

    private String createControlEventProcessorId(String controlPayloadType) {
        return Control.class.getCanonicalName() + ":" + controlPayloadType;
    }
}

