/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.requests.processors;

import org.piangles.backbone.services.Locator;
import org.piangles.backbone.services.session.SessionManagementService;
import org.piangles.core.expt.UnsupportedMediaException;
import org.piangles.gateway.CommunicationPattern;
import org.piangles.gateway.client.ClientDetails;
import org.piangles.gateway.requests.Endpoints;
import org.piangles.gateway.requests.RequestRouter;
import org.piangles.gateway.requests.dto.BooleanResponse;
import org.piangles.gateway.requests.dto.Request;
import org.piangles.gateway.requests.dto.ValidateMFATokenRequest;
import org.piangles.gateway.requests.processors.AbstractRequestProcessor;

public class ValidateMFATokenRequestProcessor
extends AbstractRequestProcessor<ValidateMFATokenRequest, BooleanResponse> {
    private SessionManagementService sessionMgmtService = Locator.getInstance().getSessionManagementService();

    public ValidateMFATokenRequestProcessor() {
        super(Endpoints.ValidateMFAToken, CommunicationPattern.RequestResponse, ValidateMFATokenRequest.class, BooleanResponse.class);
    }

    @Override
    protected BooleanResponse processRequest(ClientDetails clientDetails, Request request, ValidateMFATokenRequest validateMFARequest) throws Exception {
        boolean validation;
        BooleanResponse booleanResponse = null;
        if (RequestRouter.getInstance().getMFAManager() != null) {
            validation = RequestRouter.getInstance().getMFAManager().validateMFAToken(clientDetails, validateMFARequest.getMFAToken());
            if (validation) {
                this.sessionMgmtService.markAuthenticatedByMFA(clientDetails.getSessionDetails().getUserId(), clientDetails.getSessionDetails().getSessionId());
            }
        } else {
            throw new UnsupportedMediaException("Multi-Factor Authentication has not been setup.");
        }
        booleanResponse = new BooleanResponse(validation, validation ? "Valid MFA Token" : "Invalid MFA Token");
        return booleanResponse;
    }
}

