/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.requests.processors;

import org.piangles.backbone.services.Locator;
import org.piangles.backbone.services.auth.FailureReason;
import org.piangles.backbone.services.profile.BasicUserProfile;
import org.piangles.backbone.services.profile.UserProfileService;
import org.piangles.backbone.services.session.SessionDetails;
import org.piangles.backbone.services.session.SessionManagementException;
import org.piangles.backbone.services.session.SessionManagementService;
import org.piangles.gateway.CommunicationPattern;
import org.piangles.gateway.client.ClientDetails;
import org.piangles.gateway.requests.ClientStateDeterminator;
import org.piangles.gateway.requests.dao.UserDeviceInfo;
import org.piangles.gateway.requests.dto.LoginResponse;
import org.piangles.gateway.requests.dto.SystemInfo;
import org.piangles.gateway.requests.processors.AbstractRequestProcessor;

public abstract class AbstractAuthenticationProcessor<EndpointReq, EndpointResp>
extends AbstractRequestProcessor<EndpointReq, EndpointResp> {
    private static final String MAX_ACTIVE_SESSION_MESAGE_1 = "already has an active session";
    private static final String MAX_ACTIVE_SESSION_MESAGE_2 = "has reached maximum active sessions";
    private SessionManagementService sessionMgmtService = Locator.getInstance().getSessionManagementService();
    private UserProfileService profileService = Locator.getInstance().getUserProfileService();

    public AbstractAuthenticationProcessor(Enum<?> endpoint, Class<EndpointReq> requestClass, Class<EndpointResp> responseClass) {
        super(endpoint, CommunicationPattern.RequestResponse, requestClass, responseClass);
    }

    public LoginResponse processGuestSuccessfulLogin(String userId, ClientDetails clientDetails, SystemInfo systemInfo) throws Exception {
        boolean authenticatedByToken = false;
        boolean loggedInAsGuest = true;
        return this.processRegularSuccessfulLogin(userId, authenticatedByToken, loggedInAsGuest, System.currentTimeMillis(), clientDetails, systemInfo);
    }

    public LoginResponse processRegularSuccessfulLogin(String userId, boolean authenticatedByToken, boolean loggedInAsGuest, long lastLoggedInTimestamp, ClientDetails clientDetails, SystemInfo systemInfo) throws Exception {
        LoginResponse loginResponse = null;
        UserDeviceInfo userDeviceInfo = new UserDeviceInfo(userId, clientDetails.getHostName(), clientDetails.getIPAddress(), systemInfo);
        this.getGatewayDAO().insertUserDeviceInfo(userDeviceInfo);
        try {
            SessionDetails sessionDetails = this.sessionMgmtService.register(userId);
            this.setSessionForCurrentThread(sessionDetails);
            BasicUserProfile userProfile = this.profileService.getProfile(userId);
            String authenticationState = ClientStateDeterminator.determine(authenticatedByToken, userProfile).name();
            loginResponse = new LoginResponse(authenticationState, loggedInAsGuest, userId, sessionDetails.getSessionId(), userProfile.getPhoneNo(), sessionDetails.getInactivityExpiryTimeInSeconds(), lastLoggedInTimestamp);
            this.sessionMgmtService.updateAuthenticationState(userId, sessionDetails.getSessionId(), authenticationState);
        }
        catch (SessionManagementException e) {
            String message = e.getMessage();
            if (message.contains(MAX_ACTIVE_SESSION_MESAGE_1) || message.contains(MAX_ACTIVE_SESSION_MESAGE_2)) {
                String authenticationState = ClientStateDeterminator.determine().name();
                loginResponse = new LoginResponse(0, FailureReason.MaximumSessionCountReached, authenticationState);
            }
            throw e;
        }
        return loginResponse;
    }

    @Override
    public final boolean shouldValidateSession() {
        return false;
    }
}

