/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.requests.processors;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.piangles.core.util.reflect.TypeToken;
import org.piangles.gateway.CommunicationPattern;
import org.piangles.gateway.client.ClientDetails;
import org.piangles.gateway.requests.Endpoints;
import org.piangles.gateway.requests.RequestRouter;
import org.piangles.gateway.requests.dto.EmptyRequest;
import org.piangles.gateway.requests.dto.Request;
import org.piangles.gateway.requests.processors.AbstractRequestProcessor;

public final class ListEndpointsRequestProcessor
extends AbstractRequestProcessor<EmptyRequest, List<String>> {
    private Map<String, Endpoints> metadataEndpoints = new HashMap<String, Endpoints>();

    public ListEndpointsRequestProcessor() {
        super(Endpoints.ListEndpoints, CommunicationPattern.RequestResponse, EmptyRequest.class, new TypeToken<List<String>>(){}.getActualClass());
        this.populate(Endpoints.ListEndpoints);
        this.populate(Endpoints.EndpointMetadata);
    }

    @Override
    protected List<String> processRequest(ClientDetails clientDetails, Request request, EmptyRequest emptyRequest) throws Exception {
        return RequestRouter.getInstance().getRegisteredEndpoints().stream().filter(ep -> !this.metadataEndpoints.containsKey(ep)).collect(Collectors.toList());
    }

    @Override
    public boolean shouldValidateSession() {
        return false;
    }

    private void populate(Endpoints endpoint) {
        this.metadataEndpoints.put(endpoint.name(), endpoint);
    }
}

