/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.requests.processors;

import org.piangles.backbone.services.Locator;
import org.piangles.backbone.services.auth.AuthenticationResponse;
import org.piangles.backbone.services.auth.AuthenticationService;
import org.piangles.core.expt.NotFoundException;
import org.piangles.core.expt.ServiceRuntimeException;
import org.piangles.gateway.CommunicationPattern;
import org.piangles.gateway.client.ClientDetails;
import org.piangles.gateway.requests.Endpoints;
import org.piangles.gateway.requests.RequestRouter;
import org.piangles.gateway.requests.dto.GeneratePasswordResetTokenRequest;
import org.piangles.gateway.requests.dto.Request;
import org.piangles.gateway.requests.dto.SimpleResponse;
import org.piangles.gateway.requests.processors.AbstractRequestProcessor;

public final class GeneratePasswordResetTokenRequestProcessor
extends AbstractRequestProcessor<GeneratePasswordResetTokenRequest, SimpleResponse> {
    private AuthenticationService authService = Locator.getInstance().getAuthenticationService();

    public GeneratePasswordResetTokenRequestProcessor() {
        super(Endpoints.GeneratePasswordResetToken, CommunicationPattern.RequestResponse, GeneratePasswordResetTokenRequest.class, SimpleResponse.class);
    }

    @Override
    protected SimpleResponse processRequest(ClientDetails clientDetails, Request request, GeneratePasswordResetTokenRequest tokenRequest) throws Exception {
        SimpleResponse simpleResponse = null;
        AuthenticationResponse authResponse = this.authService.generateResetToken(tokenRequest.getEmailId());
        if (authResponse.isRequestSuccessful()) {
            if (RequestRouter.getInstance().getCommunicator() != null) {
                RequestRouter.getInstance().getCommunicator().sendGeneratePasswordResetTokenCommunication(tokenRequest.getEmailId(), authResponse);
            }
        } else {
            StringBuffer sb = new StringBuffer(authResponse.getFailureReason().name());
            authResponse.getFailureMessages().stream().map(msg -> sb.append((String)msg).append("\n"));
            switch (authResponse.getFailureReason()) {
                case AccountDoesNotExist: {
                    throw new NotFoundException(sb.toString());
                }
            }
            throw new ServiceRuntimeException("Unhandled FailureReason : " + authResponse.getFailureReason() + "\n" + sb.toString());
        }
        simpleResponse = new SimpleResponse("Please check your registered email for the token.");
        return simpleResponse;
    }

    @Override
    public boolean shouldValidateSession() {
        return false;
    }
}

