/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.requests.processors;

import org.piangles.backbone.services.Locator;
import org.piangles.backbone.services.logging.LoggingService;
import org.piangles.backbone.services.profile.BasicUserProfile;
import org.piangles.backbone.services.profile.UserProfileException;
import org.piangles.backbone.services.profile.UserProfileService;
import org.piangles.core.expt.UnsupportedMediaException;
import org.piangles.core.expt.ValidationException;
import org.piangles.gateway.client.ClientDetails;
import org.piangles.gateway.requests.Endpoints;
import org.piangles.gateway.requests.RequestRouter;
import org.piangles.gateway.requests.dto.Request;
import org.piangles.gateway.requests.dto.SimpleResponse;
import org.piangles.gateway.requests.processors.AbstractRequestProcessor;
import software.amazon.awssdk.utils.StringUtils;

public class SendMFATokenRequestProcessor
extends AbstractRequestProcessor<BasicUserProfile, SimpleResponse> {
    private LoggingService logger = Locator.getInstance().getLoggingService();
    private UserProfileService profileService = Locator.getInstance().getUserProfileService();

    public SendMFATokenRequestProcessor() {
        super(Endpoints.SendMFAToken, BasicUserProfile.class, SimpleResponse.class);
    }

    @Override
    protected SimpleResponse processRequest(ClientDetails clientDetails, Request request, BasicUserProfile upRequest) throws Exception {
        SimpleResponse simpleResponse = null;
        if (RequestRouter.getInstance().getMFAManager() != null) {
            BasicUserProfile userProfile = this.profileService.getProfile(clientDetails.getSessionDetails().getUserId());
            if (StringUtils.isBlank((CharSequence)userProfile.getPhoneNo())) {
                this.logger.info((Object)("User with UserId: " + userProfile.getUserId() + " requesting a Token for setting up MFA."));
                this.updateUserProfile(userProfile, upRequest.getPhoneNo());
            } else if (StringUtils.isNotBlank((CharSequence)upRequest.getPhoneNo())) {
                if (!userProfile.getPhoneNo().equals(upRequest.getPhoneNo())) {
                    this.logger.info((Object)("User with UserId: " + userProfile.getUserId() + " requesting a Token for setting up MFA for updated phone number."));
                    this.updateUserProfile(userProfile, upRequest.getPhoneNo());
                } else {
                    this.logger.info((Object)("User with UserId: " + userProfile.getUserId() + " requesting a MFA Token for a previously registered phone number."));
                }
            } else {
                this.logger.info((Object)("User with UserId: " + userProfile.getUserId() + " requesting a Resend->MFAToken."));
            }
        } else {
            throw new UnsupportedMediaException("Multi-Factor Authentication has not been setup.");
        }
        RequestRouter.getInstance().getMFAManager().sendMFAToken(clientDetails);
        simpleResponse = new SimpleResponse("We sent a security code to your device.");
        return simpleResponse;
    }

    private void updateUserProfile(BasicUserProfile userProfile, String phoneNo) throws UserProfileException {
        if (StringUtils.isBlank((CharSequence)phoneNo)) {
            throw new ValidationException(Endpoints.SendMFAToken.name() + " Phone Number is blank.");
        }
        phoneNo = phoneNo.trim();
        userProfile = new BasicUserProfile(userProfile.getUserId(), userProfile.getFirstName(), userProfile.getLastName(), userProfile.getEMailId(), userProfile.isEmailIdVerified(), phoneNo, false, false);
        this.profileService.updateProfile(userProfile.getUserId(), userProfile);
    }
}

