/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.requests.processors;

import org.piangles.backbone.services.Locator;
import org.piangles.backbone.services.prefs.UserPreferences;
import org.piangles.backbone.services.prefs.UserPreferencesService;
import org.piangles.core.expt.ValidationException;
import org.piangles.gateway.client.ClientDetails;
import org.piangles.gateway.requests.Endpoints;
import org.piangles.gateway.requests.dto.Request;
import org.piangles.gateway.requests.dto.SimpleResponse;
import org.piangles.gateway.requests.processors.AbstractRequestProcessor;

public class UpdateUserPreferencesRequestProcessor
extends AbstractRequestProcessor<UserPreferences, SimpleResponse> {
    private UserPreferencesService upService = Locator.getInstance().getUserPreferencesService();

    public UpdateUserPreferencesRequestProcessor() {
        super(Endpoints.UpdateUserPreferences, UserPreferences.class, SimpleResponse.class);
    }

    @Override
    protected SimpleResponse processRequest(ClientDetails clientDetails, Request request, UserPreferences userPrefs) throws Exception {
        if (!clientDetails.getSessionDetails().getUserId().equalsIgnoreCase(userPrefs.getUserId())) {
            throw new ValidationException("UserPreferences does not belong to current user.");
        }
        this.upService.persistUserPreferences(clientDetails.getSessionDetails().getUserId(), userPrefs);
        return new SimpleResponse("UserPreferences persisted successfully.");
    }
}

