/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.events;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.piangles.backbone.services.Locator;
import org.piangles.backbone.services.logging.LoggingService;
import org.piangles.backbone.services.msg.Event;
import org.piangles.backbone.services.msg.Topic;
import org.piangles.core.resources.ConsumerProperties;
import org.piangles.core.resources.ResourceException;
import org.piangles.gateway.client.ClientDetails;
import org.piangles.gateway.events.EventDispatcher;
import org.piangles.gateway.events.EventListener;
import org.piangles.gateway.events.EventProcessor;
import org.piangles.gateway.events.EventRouter;

public class EventProcessingManager
implements EventDispatcher {
    private LoggingService logger = Locator.getInstance().getLoggingService();
    private ClientDetails clientDetails = null;
    private Map<Topic, UUID> topicTraceIdMap = null;
    private ConsumerProperties consumerProps = null;
    private EventListener eventListener = null;

    public EventProcessingManager(ClientDetails clientDetails) throws ResourceException {
        this.clientDetails = clientDetails;
        this.topicTraceIdMap = new HashMap<Topic, UUID>();
        this.consumerProps = new ConsumerProperties(clientDetails.getSessionDetails().getUserId());
        this.eventListener = new EventListener(clientDetails, this.consumerProps, this);
        this.eventListener.start();
    }

    public synchronized void stop() {
        if (this.eventListener != null) {
            this.eventListener.markForStopping();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void subscribeToTopics(Map<Topic, UUID> topicTraceIdMap) {
        this.logger.info((Object)("Subscribing to " + topicTraceIdMap.keySet()));
        this.topicTraceIdMap.putAll(topicTraceIdMap);
        List modifiedTopics = this.topicTraceIdMap.keySet().stream().map(topic -> {
            ConsumerProperties consumerProperties = this.consumerProps;
            consumerProperties.getClass();
            return new ConsumerProperties.Topic(consumerProperties, topic.getTopicName(), topic.getPartition(), topic.shouldReadEarliest());
        }).collect(Collectors.toList());
        ConsumerProperties consumerProperties = this.consumerProps;
        synchronized (consumerProperties) {
            this.consumerProps.setTopics(modifiedTopics);
            this.eventListener.topicsHaveChanged();
        }
    }

    public synchronized void unsubscribeTopics(List<Topic> topics) {
        this.logger.info((Object)("Unsubscribing to " + topics));
        topics.stream().forEach(topic -> this.topicTraceIdMap.remove(topic));
    }

    @Override
    public synchronized void dispatchAllEvents(Map<Event, Topic> toBeDispactedTopicEventMap) throws Exception {
        for (Map.Entry<Event, Topic> entry : toBeDispactedTopicEventMap.entrySet()) {
            Event event = entry.getKey();
            try {
                EventProcessor mp = EventRouter.getInstance().getProcessor(event);
                if (mp == null) continue;
                event.setTraceId(this.topicTraceIdMap.get(entry.getValue()));
                mp.process(this.clientDetails, event);
            }
            catch (Exception e) {
                this.logger.error((Object)("Unexpected Eror while processing Event : " + event), (Throwable)e);
            }
        }
    }
}

