/*
 * Decompiled with CFR 0.152.
 */
package org.piangles.gateway.requests;

import org.piangles.backbone.services.config.DefaultConfigProvider;
import org.piangles.core.resources.RedisCache;
import org.piangles.core.resources.ResourceManager;
import org.piangles.core.util.abstractions.ConfigProvider;
import org.piangles.gateway.GatewayService;
import org.piangles.gateway.requests.TraceIdStore;

public class CacheTraceIdStore
implements TraceIdStore {
    private static final String GATEWAY_COMPONENT_ID = "4f1fc058-75d9-4956-a5df-da4697c4e5b3";
    private RedisCache redisCache = ResourceManager.getInstance().getRedisCache((ConfigProvider)new DefaultConfigProvider(GatewayService.NAME, "4f1fc058-75d9-4956-a5df-da4697c4e5b3"));

    @Override
    public void put(String traceId) throws Exception {
        this.redisCache.execute(jedis -> {
            jedis.set(this.createKey(traceId), "");
            return null;
        });
    }

    @Override
    public boolean exists(String traceId) throws Exception {
        String found = (String)this.redisCache.execute(jedis -> jedis.get(this.createKey(traceId)));
        return found != null;
    }

    private String createKey(String traceId) {
        return "traceId:" + traceId;
    }
}

