/*
 * Decompiled with CFR 0.152.
 */
package org.piax.common;

import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Properties;
import org.piax.common.Option;

public class Config {
    public static final String PROPERTY_FILE = "piax.properties";

    public static void load(Properties properties) {
        try {
            for (Object k : properties.keySet()) {
                String key = (String)k;
                String value = properties.getProperty(key);
                int last = key.lastIndexOf(46);
                if (last < 0) {
                    System.err.println("Parse error: each property should have '<class name>.<option name> [= value]'");
                    System.exit(1);
                }
                String clazz = key.substring(0, last);
                Class<?> clz = Class.forName(clazz);
                String field = key.substring(last + 1);
                Field f = clz.getField(field);
                Option o = (Option)f.get(null);
                ArrayList<String> arg = new ArrayList<String>();
                arg.add(value);
                o.parse(arg);
            }
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(1);
        }
    }

    public static void load(String file) {
        Properties properties = new Properties();
        try {
            FileInputStream inputStream = new FileInputStream(file);
            properties.load(inputStream);
            Config.load(properties);
            ((InputStream)inputStream).close();
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(1);
        }
    }

    public static void load() {
        Config.load(PROPERTY_FILE);
    }

    public static void main(String[] args) {
    }
}

