/*
 * Decompiled with CFR 0.152.
 */
package org.piax.common;

import java.io.Serializable;
import org.piax.common.PeerId;
import org.piax.util.KeyComparator;
import org.piax.util.RandomUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DdllKey
implements Comparable<DdllKey>,
Serializable,
Cloneable {
    private static final Logger logger = LoggerFactory.getLogger(DdllKey.class);
    private static final long serialVersionUID = 1L;
    private static KeyComparator keyComp = KeyComparator.getInstance();
    public final Comparable<?> rawKey;
    final PeerId peerId;
    public final String id;
    public final Object appData;
    private final int hash;
    private final int nonce;

    private DdllKey(boolean dummy, Comparable<?> key, PeerId peerId, String id, int nonce, Object appData) {
        this.rawKey = key;
        this.peerId = peerId;
        this.id = id;
        int h = this.rawKey.hashCode();
        this.nonce = nonce;
        this.hash = (h ^= peerId.hashCode()) ^ nonce;
        this.appData = appData;
    }

    public DdllKey(Comparable<?> key, PeerId peerId, String id, int nonce, Object appData) {
        this(true, key, peerId, id, nonce, appData);
        assert (!peerId.isMinusInfinity() && !peerId.isPlusInfinity());
    }

    public DdllKey(Comparable<?> key, PeerId peerId, String id, Object appData) {
        this(true, key, peerId, id, peerId.isMinusInfinity() || peerId.isPlusInfinity() ? 0 : RandomUtil.getSharedRandom().nextInt(), appData);
    }

    public DdllKey(Comparable<?> key, PeerId peerId) {
        this(key, peerId, "", null);
    }

    public DdllKey(Comparable<?> key, PeerId peerId, int nonce) {
        this(key, peerId, "", nonce, null);
    }

    public Comparable<?> getRawKey() {
        return this.rawKey;
    }

    public PeerId getPeerId() {
        return this.peerId;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public int compareTo(DdllKey o) {
        int cmp = keyComp.compare(this.rawKey, o.rawKey);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.peerId.compareTo(o.peerId);
        if (cmp != 0) {
            return cmp;
        }
        cmp = Integer.compare(this.nonce, o.nonce);
        if (cmp != 0) {
            return cmp;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DdllKey)) {
            return false;
        }
        DdllKey o = (DdllKey)obj;
        if (!this.rawKey.equals(o.rawKey)) {
            return false;
        }
        if (!this.peerId.equals(o.peerId)) {
            return false;
        }
        if (!this.id.equals(o.id)) {
            return false;
        }
        return this.nonce == o.nonce;
    }

    public boolean equals2(DdllKey o) {
        if (!this.rawKey.equals(o.rawKey)) {
            return false;
        }
        if (!this.peerId.equals(o.peerId)) {
            return false;
        }
        return this.nonce == o.nonce;
    }

    public int hashCode() {
        return this.hash ^ this.id.hashCode();
    }

    public int hashCode2() {
        return this.hash;
    }

    public String toString() {
        String s = "null";
        if (this.peerId != null && (s = this.peerId.toString()).length() > 4) {
            s = s.substring(0, 4);
        }
        return String.valueOf(this.rawKey.toString()) + "!" + s + (this.id.equals("") ? "" : "." + this.id);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public DdllKey getIdChangedKey(String id) {
        return new DdllKey(true, this.rawKey, this.peerId, id, this.nonce, this.appData);
    }
}

